/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.panel.JDebuggerPanel;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SetValueDialog
extends JDialog {
    private static final long serialVersionUID = -1111111202103121002L;
    private final transient MainWindow mainWindow;
    private final transient JDebuggerPanel.ValueTreeNode valNode;

    public SetValueDialog(MainWindow mainWindow, JDebuggerPanel.ValueTreeNode valNode) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.valNode = valNode;
        this.initUI();
        UiUtils.addEscapeShortCutToDispose(this);
        this.setTitle(valNode.toString());
    }

    private void initUI() {
        final JTextField valField = new JTextField();
        TextStandardActions.attach(valField);
        JPanel valPane = new JPanel(new BorderLayout(5, 5));
        valPane.add((Component)new JLabel(NLS.str("set_value_dialog.label_value")), "West");
        valPane.add((Component)valField, "Center");
        JPanel btnPane = new JPanel();
        btnPane.setLayout(new BoxLayout(btnPane, 2));
        final JButton setValueBtn = new JButton(NLS.str("set_value_dialog.btn_set"));
        btnPane.add(new Label());
        btnPane.add(setValueBtn);
        UiUtils.addKeyBinding((JComponent)valField, KeyStroke.getKeyStroke(10, 0), "set value", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                setValueBtn.doClick();
            }
        });
        JPanel typePane = new JPanel();
        typePane.setLayout(new BoxLayout(typePane, 2));
        final ArrayList<JRadioButton> rbs = new ArrayList<JRadioButton>(6);
        rbs.add(new JRadioButton("int"));
        rbs.add(new JRadioButton("String"));
        rbs.add(new JRadioButton("long"));
        rbs.add(new JRadioButton("float"));
        rbs.add(new JRadioButton("double"));
        rbs.add(new JRadioButton("Object id"));
        ((JRadioButton)rbs.get(0)).setSelected(true);
        ButtonGroup rbGroup = new ButtonGroup();
        rbs.forEach(rbGroup::add);
        rbs.forEach(typePane::add);
        JPanel mainPane = new JPanel(new BorderLayout(5, 5));
        mainPane.add((Component)typePane, "North");
        mainPane.add((Component)valPane, "Center");
        mainPane.add((Component)btnPane, "South");
        mainPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(mainPane);
        this.setTitle(NLS.str("set_value_dialog.title"));
        this.pack();
        this.setSize(480, 160);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.MODELESS);
        UiUtils.addEscapeShortCutToDispose(this);
        setValueBtn.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1111111202103260220L;

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ok;
                try {
                    Map.Entry<ArgType, Object> type = this.getType();
                    if (type == null) {
                        UiUtils.showMessageBox(SetValueDialog.this.mainWindow, NLS.str("set_value_dialog.sel_type"));
                        return;
                    }
                    ok = SetValueDialog.this.mainWindow.getDebuggerPanel().getDbgController().modifyRegValue(SetValueDialog.this.valNode, type.getKey(), type.getValue());
                }
                catch (JadxRuntimeException except) {
                    UiUtils.showMessageBox(SetValueDialog.this.mainWindow, except.getMessage());
                    return;
                }
                if (ok) {
                    SetValueDialog.this.dispose();
                } else {
                    UiUtils.showMessageBox(SetValueDialog.this.mainWindow, NLS.str("set_value_dialog.neg_msg"));
                }
            }

            private Map.Entry<ArgType, Object> getType() {
                String val = valField.getText();
                for (JRadioButton rb : rbs) {
                    if (!rb.isSelected()) continue;
                    switch (rb.getText()) {
                        case "int": {
                            return new AbstractMap.SimpleEntry<ArgType, Object>(ArgType.INT, Integer.valueOf(val));
                        }
                        case "String": {
                            return new AbstractMap.SimpleEntry<ArgType, Object>(ArgType.STRING, val);
                        }
                        case "long": {
                            return new AbstractMap.SimpleEntry<ArgType, Object>(ArgType.LONG, Long.valueOf(val));
                        }
                        case "float": {
                            return new AbstractMap.SimpleEntry<ArgType, Object>(ArgType.FLOAT, Float.valueOf(val));
                        }
                        case "double": {
                            return new AbstractMap.SimpleEntry<ArgType, Object>(ArgType.DOUBLE, Double.valueOf(val));
                        }
                        case "Object id": {
                            return new AbstractMap.SimpleEntry<ArgType, Object>(ArgType.OBJECT, Long.valueOf(val));
                        }
                    }
                    throw new JadxRuntimeException("Unexpected type: " + rb.getText());
                }
                return null;
            }
        });
    }
}

