/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Map;
import org.apache.commons.text.translate.EntityArrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EntityArraysTest {
    EntityArraysTest() {
    }

    @Test
    void testAposMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.APOS_ESCAPE, EntityArrays.APOS_UNESCAPE);
    }

    @Test
    void testBasicMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.BASIC_ESCAPE, EntityArrays.BASIC_UNESCAPE);
    }

    @Test
    void testConstructorExists() {
        new EntityArrays();
    }

    private void testEscapeVsUnescapeMaps(Map<CharSequence, CharSequence> escapeMap, Map<CharSequence, CharSequence> unescapeMap) {
        for (CharSequence escapeKey : escapeMap.keySet()) {
            for (CharSequence unescapeKey : unescapeMap.keySet()) {
                if (escapeKey != unescapeMap.get(unescapeKey)) continue;
                Assertions.assertEquals((Object)escapeMap.get(escapeKey), (Object)unescapeKey);
            }
        }
    }

    @Test
    void testForDuplicatedDeclaredMapKeys() throws Exception {
        String packageDirectory = EntityArraysTest.class.getPackage().getName().replace(".", "/");
        try (BufferedReader br = new BufferedReader(new FileReader("src/main/java/" + packageDirectory + "/EntityArrays.java"));){
            String line;
            int mapDeclarationCounter = 0;
            while ((line = br.readLine()) != null) {
                if (line.contains("new HashMap<>();")) {
                    mapDeclarationCounter = 0;
                    continue;
                }
                if (line.contains(".put(")) {
                    ++mapDeclarationCounter;
                    continue;
                }
                if (!line.contains("Collections.unmodifiableMap(initialMap);")) continue;
                String mapVariableName = line.split("=")[0].trim();
                Map mapValue = (Map)EntityArrays.class.getDeclaredField(mapVariableName).get(EntityArrays.class);
                Assertions.assertEquals((int)mapDeclarationCounter, (int)mapValue.size());
            }
        }
    }

    @Test
    void testForDuplicateDeclaredMapValuesAposMap() {
        Assertions.assertEquals((int)EntityArrays.APOS_UNESCAPE.size(), (int)EntityArrays.APOS_ESCAPE.size());
    }

    @Test
    void testForDuplicateDeclaredMapValuesBasicMap() {
        Assertions.assertEquals((int)EntityArrays.BASIC_ESCAPE.size(), (int)EntityArrays.BASIC_UNESCAPE.size());
    }

    @Test
    void testForDuplicateDeclaredMapValuesHtml40ExtendedMap() {
        Assertions.assertEquals((int)EntityArrays.HTML40_EXTENDED_ESCAPE.size(), (int)EntityArrays.HTML40_EXTENDED_UNESCAPE.size());
    }

    @Test
    void testForDuplicateDeclaredMapValuesISO8859Map() {
        Assertions.assertEquals((int)EntityArrays.ISO8859_1_ESCAPE.size(), (int)EntityArrays.ISO8859_1_UNESCAPE.size());
    }

    @Test
    void testForDuplicateDeclaredMapValuesJavaCtrlCharsMap() {
        Assertions.assertEquals((int)EntityArrays.JAVA_CTRL_CHARS_ESCAPE.size(), (int)EntityArrays.JAVA_CTRL_CHARS_UNESCAPE.size());
    }

    @Test
    void testHtml40ExtendedMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.HTML40_EXTENDED_ESCAPE, EntityArrays.HTML40_EXTENDED_UNESCAPE);
    }

    @Test
    void testISO8859Map() {
        this.testEscapeVsUnescapeMaps(EntityArrays.ISO8859_1_ESCAPE, EntityArrays.ISO8859_1_UNESCAPE);
    }

    @Test
    void testJavaCtrlCharsMap() {
        this.testEscapeVsUnescapeMaps(EntityArrays.JAVA_CTRL_CHARS_ESCAPE, EntityArrays.JAVA_CTRL_CHARS_UNESCAPE);
    }
}

