/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.text.lookup.DnsStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DnsStringLookupTest {
    DnsStringLookupTest() {
    }

    @Test
    void testAddressFromHostAddress() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getHostAddress(), (Object)DnsStringLookup.INSTANCE.apply("address|" + localHost.getHostAddress()));
    }

    @Test
    void testAddressFromHostName() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getHostAddress(), (Object)DnsStringLookup.INSTANCE.apply("address|" + localHost.getHostName()));
    }

    @Test
    void testCanonicalNameFromHostAddress() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getCanonicalHostName(), (Object)DnsStringLookup.INSTANCE.apply("canonical-name|" + localHost.getHostAddress()));
    }

    @Test
    void testCanonicalNameFromHostName() throws UnknownHostException {
        InetAddress localHost = InetAddress.getLocalHost();
        Assertions.assertEquals((Object)localHost.getCanonicalHostName(), (Object)DnsStringLookup.INSTANCE.apply("canonical-name|" + localHost.getHostName()));
    }

    @Test
    void testName() throws UnknownHostException {
        String address = InetAddress.getLocalHost().getHostAddress();
        InetAddress[] localHostAll = InetAddress.getAllByName(address);
        boolean matched = false;
        for (InetAddress localHost : localHostAll) {
            if (!localHost.getHostName().equals(DnsStringLookup.INSTANCE.apply("name|" + address + ""))) continue;
            matched = true;
        }
        Assertions.assertTrue((boolean)matched);
    }

    @Test
    void testNull() {
        Assertions.assertNull((Object)DnsStringLookup.INSTANCE.apply(null));
    }

    @Test
    void testToString() {
        Assertions.assertFalse((boolean)DnsStringLookup.INSTANCE.toString().isEmpty());
    }
}

