/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.layout;

import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.pinkmatter.pandora.Artifact;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LayoutArtifactUtils {
    public static Map<String, Object> createCenterMap(Point point) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (point != null) {
            LayoutArtifactUtils.setPoint(map, point);
        }
        return map;
    }

    public static Map<String, Object> createPathMap(List<Point> path) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (path != null && !path.isEmpty()) {
            Map[] pathArr = new Map[path.size()];
            int pointNum = 0;
            for (Point point : path) {
                HashMap<String, Object> pathMap = new HashMap<String, Object>(2);
                LayoutArtifactUtils.setPoint(pathMap, point);
                pathArr[pointNum] = pathMap;
                ++pointNum;
            }
            map.put("path", pathArr);
        }
        return map;
    }

    public static Point getCenter(Artifact entityArtifact) {
        return LayoutArtifactUtils.getPoint((Map)entityArtifact);
    }

    public static List<Point> getPath(Artifact linkArtifact) throws GraphStoreException {
        ArrayList<Point> path = null;
        Object pathObj = linkArtifact.get("path");
        Map[] pathArr = (Map[])pathObj;
        if (pathArr != null && pathArr.length > 0) {
            path = new ArrayList<Point>(pathArr.length);
            for (Map pointMap : pathArr) {
                Point point = LayoutArtifactUtils.getPoint(pointMap);
                if (point == null) {
                    throw new GraphStoreException("Path may not contain null point");
                }
                path.add(point);
            }
        }
        return path;
    }

    public static Point getPoint(Map pointMap) {
        Integer x = (Integer)pointMap.get("x");
        Integer y = (Integer)pointMap.get("y");
        return x == null || y == null ? null : new Point(x, y);
    }

    public static void setPoint(Map<String, Object> map, Point point) {
        map.put("x", point.x);
        map.put("y", point.y);
    }
}

