/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.pandora.data;

import com.paterva.maltego.core.EntityID;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class EntityTypeCache {
    private static final Logger LOG = Logger.getLogger(EntityTypeCache.class.getName());
    private Map<EntityID, String> _types;
    private Map<String, Integer> _typeCount;

    EntityTypeCache() {
    }

    public synchronized boolean isInitialized() {
        return this._types != null;
    }

    public synchronized void initialize(Map<EntityID, String> types) {
        this._types = types;
        this._typeCount = new HashMap<String, Integer>();
        for (Map.Entry<EntityID, String> entry : types.entrySet()) {
            String type = entry.getValue().intern();
            this.onTypeAdded(type);
        }
        LOG.log(Level.FINE, "Initialized with types\n{0}", types);
    }

    public synchronized void uninitialize() {
        this._types = null;
        this._typeCount = null;
    }

    public synchronized Set<String> getTypes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Type cache not initialized");
        }
        return this._typeCount.keySet();
    }

    public synchronized void putType(EntityID id, String type) {
        LOG.log(Level.FINE, "Set type: {0}->{1}", new Object[]{id, type});
        if (!this.isInitialized()) {
            throw new IllegalStateException("Type cache not initialized");
        }
        if (type == null) {
            throw new IllegalArgumentException("Type may not be null");
        }
        String oldType = this._types.get(id);
        if (!type.equals(oldType)) {
            type = type.intern();
            this._types.put(id, type);
            this.onTypeRemoved(oldType);
            this.onTypeAdded(type);
        }
    }

    public synchronized String getType(EntityID id) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Type cache not initialized");
        }
        String type = this._types.get(id);
        if (type == null) {
            LOG.log(Level.SEVERE, "Type not found for id: {0}", id);
            type = "maltego.Unknown";
        }
        return type;
    }

    public synchronized String removeType(EntityID id) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Type cache not initialized");
        }
        String type = this._types.remove(id);
        if (type == null) {
            LOG.log(Level.SEVERE, "Type not found for id: {0}", id);
        } else {
            LOG.log(Level.FINE, "Type removed: {0}->{1}", new Object[]{id, type});
            this.onTypeRemoved(type);
        }
        return type;
    }

    public synchronized int getTypeCount(String type) {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Type cache not initialized");
        }
        Integer count = this._typeCount.get(type);
        return count != null ? count : 0;
    }

    private void onTypeRemoved(String type) {
        if (type == null) {
            return;
        }
        Integer count = this._typeCount.get(type);
        if (count == null || count == 0) {
            LOG.log(Level.SEVERE, "Type counts out of sync for : {0}", type);
            count = 0;
        }
        if (count <= 1) {
            this._typeCount.remove(type);
        } else {
            this._typeCount.put(type, count - 1);
        }
    }

    private void onTypeAdded(String type) {
        Integer count = this._typeCount.get(type);
        count = count == null ? 1 : count + 1;
        this._typeCount.put(type, count);
    }
}

