/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.graph.store.memory;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.AbstractBatchUpdatable;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutMods;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import java.awt.Point;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InMemoryGraphLayoutStore
extends AbstractBatchUpdatable<Boolean>
implements GraphLayoutStore,
GraphLayoutReader,
GraphLayoutWriter {
    private final Map<EntityID, Point> _centers = new HashMap<EntityID, Point>();
    private final Map<LinkID, List<Point>> _paths = new HashMap<LinkID, List<Point>>();
    private final PropertyChangeSupport _changeSupport = new PropertyChangeSupport((Object)this);
    private GraphLayoutMods _eventMods;

    public GraphLayoutReader getLayoutReader() {
        return this;
    }

    public GraphLayoutWriter getLayoutWriter() {
        return this;
    }

    public void addEntities(Map<EntityID, Point> centers) throws GraphStoreException {
        this.beginUpdate();
        try {
            this.setCenters(centers);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntities(Collection<EntityID> entityIDs) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (EntityID entityID : entityIDs) {
                this.addEntity(entityID);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void addEntity(EntityID entityID) throws GraphStoreException {
        this.beginUpdate();
        try {
            this._centers.put(entityID, null);
        }
        finally {
            this.endUpdate();
        }
    }

    public void addLinks(Map<LinkID, List<Point>> paths) throws GraphStoreException {
        this.beginUpdate();
        try {
            this.setPaths(paths);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLinks(Collection<LinkID> linkIDs) throws GraphStoreException {
        this.beginUpdate();
        try {
            for (LinkID linkID : linkIDs) {
                this.addLink(linkID);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void addLink(LinkID linkID) throws GraphStoreException {
        this.beginUpdate();
        try {
            this._paths.put(linkID, null);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenters(Map<EntityID, Point> centers) {
        this.beginUpdate();
        try {
            for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
                EntityID entityID = entry.getKey();
                Point center = entry.getValue();
                this.setCenter(entityID, center);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setCenter(EntityID entity, Point center) {
        if (center == null) {
            return;
        }
        this.beginUpdate();
        try {
            this._centers.put(entity, center);
            this.getEventMods().getCenters().put(entity, center);
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaths(Map<LinkID, List<Point>> paths) {
        this.beginUpdate();
        try {
            for (Map.Entry<LinkID, List<Point>> entry : paths.entrySet()) {
                LinkID linkID = entry.getKey();
                List<Point> path = entry.getValue();
                this.setPath(linkID, path);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setPath(LinkID link, List<Point> path) {
        if (path == null) {
            return;
        }
        this.beginUpdate();
        try {
            this._paths.put(link, path);
            this.getEventMods().getPaths().put(link, path);
        }
        finally {
            this.endUpdate();
        }
    }

    public void removeEntities(Collection<EntityID> entities) {
        this.remove(entities, Collections.EMPTY_SET);
    }

    public void removeEntity(EntityID entityID) throws GraphStoreException {
        this.removeEntities(Collections.singleton(entityID));
    }

    public void removeLinks(Collection<LinkID> links) {
        this.remove(Collections.EMPTY_SET, links);
    }

    public void removeLink(LinkID linkID) throws GraphStoreException {
        this.removeLinks(Collections.singleton(linkID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection<EntityID> entities, Collection<LinkID> links) {
        this.beginUpdate();
        try {
            for (EntityID entityID : entities) {
                this._centers.remove(entityID);
                this.getEventMods().getCenters().remove(entityID);
            }
            for (LinkID linkID : links) {
                this._paths.remove(linkID);
                this.getEventMods().getPaths().remove(linkID);
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void clear() {
        this.beginUpdate();
        try {
            this._centers.clear();
            this._paths.clear();
            this.getEventMods().getCenters().clear();
            this.getEventMods().getPaths().clear();
        }
        finally {
            this.endUpdate();
        }
    }

    public int getEntityCount() {
        return this._centers.size();
    }

    public int getLinkCount() {
        return this._paths.size();
    }

    public boolean exists(EntityID entityID) {
        return this._centers.containsKey(entityID);
    }

    public boolean exists(LinkID linkID) {
        return this._paths.containsKey(linkID);
    }

    public Map<EntityID, Point> getAllCenters() {
        return Collections.unmodifiableMap(this._centers);
    }

    public Map<LinkID, List<Point>> getAllPaths() {
        return Collections.unmodifiableMap(this._paths);
    }

    public Map<EntityID, Point> getCenters(Collection<EntityID> entities) {
        HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>();
        for (EntityID entityID : entities) {
            centers.put(entityID, this._centers.get(entityID));
        }
        return centers;
    }

    public Point getCenter(EntityID entity) {
        return this._centers.get(entity);
    }

    public Map<LinkID, List<Point>> getPaths(Collection<LinkID> links) {
        HashMap<LinkID, List<Point>> paths = new HashMap<LinkID, List<Point>>();
        for (LinkID linkID : links) {
            paths.put(linkID, this._paths.get(linkID));
        }
        return paths;
    }

    public List<Point> getPath(LinkID link) {
        return Collections.unmodifiableList(this._paths.get(link));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._changeSupport.removePropertyChangeListener(listener);
    }

    protected void fireEvent() {
        if (this._eventMods != null && !this._eventMods.isEmpty()) {
            GraphLayoutMods eventMods = this._eventMods;
            this._eventMods = null;
            if (!eventMods.isEmpty()) {
                eventMods.makeReadOnly();
                this._changeSupport.firePropertyChange("layoutModified", null, eventMods);
            }
        }
    }

    private GraphLayoutMods getEventMods() {
        if (this._eventMods == null) {
            this._eventMods = new GraphLayoutMods();
        }
        return this._eventMods;
    }
}

