/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.ui;

import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.find.files.FindInFilesInput;
import com.paterva.maltego.find.files.impl.FindInputSerializer;
import com.paterva.maltego.find.files.ui.FindSettingsPanel;
import java.io.File;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class FindSettingsController {
    private FindSettingsPanel _panel;

    public FindSettingsPanel getComponent() {
        if (this._panel == null) {
            this._panel = new FindSettingsPanel();
            this.putSettings(FindInputSerializer.load());
        }
        return this._panel;
    }

    public void setEnabled(boolean enabled) {
        this._panel.setEnabled(enabled);
    }

    public void putSettings(FindInFilesInput input) {
        this._panel.setSearchString(input.getText());
        this._panel.setIsRegex(input.isRegex());
        this._panel.setRecursive(input.isRecursive());
        this._panel.setCaseSensitive(input.isCaseSensitive());
        this._panel.setSearchEntities(input.isSearchEntities());
        this._panel.setSearchLinks(input.isSearchLinks());
        this._panel.setSearchValue(input.isSearchValue());
        this._panel.setSearchProperties(input.isSearchProperties());
        this._panel.setSearchDisplayInfo(input.isSearchDisplayInfo());
        this._panel.setSearchNotes(input.isSearchNotes());
    }

    public FindInFilesInput getSettings() {
        String searchString = this._panel.getSearchString();
        String path = this._panel.getPath();
        FileObject folder = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(path)));
        if (folder == null || !folder.isFolder()) {
            this._panel.setError("Invalid search directory specified.");
            return null;
        }
        this._panel.savePath();
        FindInFilesInput input = new FindInFilesInput();
        input.setFolder(folder);
        input.setRecursive(this._panel.isRecursive());
        input.setText(searchString);
        input.setIsRegex(this._panel.isRegex());
        input.setSearchEntities(this._panel.isSearchEntities());
        input.setSearchLinks(this._panel.isSearchLinks());
        input.setSearchValue(this._panel.isSearchValue());
        input.setSearchProperties(this._panel.isSearchProperties());
        input.setSearchDisplayInfo(this._panel.isSearchDisplayInfo());
        input.setSearchNotes(this._panel.isSearchNotes());
        input.setCaseSensitive(this._panel.isCaseSensitive());
        Object entityType = this._panel.getEntityType();
        if (entityType instanceof MaltegoEntitySpec) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)entityType;
            input.setEntityType(spec.getTypeName());
        }
        FindInputSerializer.save(input);
        return input;
    }
}

