/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner;

import com.paterva.maltego.transform.api.TransformMessage;
import com.paterva.maltego.transform.runner.TransformMessageWindow;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.typing.TypeNameValidatorLogger;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTypeNameValidatorLogger
extends TypeNameValidatorLogger {
    private static final Logger LOG = Logger.getLogger(DefaultTypeNameValidatorLogger.class.getName());
    private final List<String> typeNameStartup = new ArrayList<String>();
    private final List<String> typeNameGraphs = new ArrayList<String>();

    public void handleIfInvalid(String entityDisplayName, String typeName, String propertyName, String graphID) {
        String item = this.getItemString(typeName, propertyName);
        boolean checked = true;
        if (graphID == null && !this.typeNameStartup.contains(item)) {
            this.typeNameStartup.add(item);
            checked = false;
        } else if (graphID != null && !this.typeNameGraphs.contains(item)) {
            this.typeNameGraphs.add(item);
            checked = false;
        }
        if (!(checked || propertyName != null && TypeNameValidator.checkName((String)propertyName) == null)) {
            this.logOrDisplay(entityDisplayName, typeName, propertyName, graphID);
        }
    }

    private String getItemString(String typeName, String propertyName) {
        return (StringUtilities.isNullOrEmpty((String)typeName) ? "" : typeName.toLowerCase()) + ";;;" + (StringUtilities.isNullOrEmpty((String)propertyName) ? "" : propertyName.toLowerCase());
    }

    private void logOrDisplay(String entityDisplayName, String typeName, String propertyName, String graphID) {
        if (graphID == null) {
            LOG.log(Level.WARNING, "Invalid property name: Entity=\"{0}\" with ID=\"{1}\", Property=\"{2}\". {3}", new String[]{entityDisplayName, typeName, propertyName, "Chars allowed: alphabetical, numbers (not at start) and .-_ (not consecutive, nor at start or end)."});
        } else {
            TransformMessageWindow window = TransformMessageWindow.getDefault();
            window.write(TransformMessage.Severity.Warning, "Invalid property name: Entity=\"" + entityDisplayName + "\" with ID=\"" + typeName + "\", Property=\"" + propertyName + "\". " + "Chars allowed: alphabetical, numbers (not at start) and .-_ (not consecutive, nor at start or end).");
        }
    }
}

