/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.discovery.DiscoveryException;
import com.paterva.maltego.transform.discovery.DiscoveryResult;
import com.paterva.maltego.transform.discovery.ProgressCallback;
import com.paterva.maltego.transform.discovery.TransformFinder;
import com.paterva.maltego.transform.discovery.TransformServerDetail;
import com.paterva.maltego.transform.discovery.TransformServerListing;
import com.paterva.maltego.transform.discovery.TransformServerListingProvider;
import com.paterva.maltego.transform.protocol.EntitySpecTranslatorFactory;
import com.paterva.maltego.transform.protocol.TransformTranslatorFactory;
import com.paterva.maltego.transform.protocol.api.EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.api.OAuthAuthenticatorInfo;
import com.paterva.maltego.transform.protocol.api.TransformDiscoverySettings;
import com.paterva.maltego.transform.protocol.api.TransformInfo;
import com.paterva.maltego.transform.protocol.api.TransformListInfo;
import com.paterva.maltego.transform.protocol.api.TransformSource;
import com.paterva.maltego.transform.protocol.api.TransformSourceFactory;
import com.paterva.maltego.transform.protocol.api.TransformTranslator;
import com.paterva.maltego.transform.protocol.v2api.V2TransformSetRepository;
import com.paterva.maltego.transform.protocol.v2api.WebServiceTranslator;
import com.paterva.maltego.util.FastURL;
import com.paterva.maltego.util.NamedThreadFactory;
import com.paterva.maltego.util.SlownessDetector;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class DefaultTransformFinder
extends TransformFinder {
    private static final Logger LOG = Logger.getLogger(DefaultTransformFinder.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryResult<TransformServerListing> listTransforms(TransformServerDetail[] references, ProgressCallback cb) throws DiscoveryException {
        List errors = Collections.synchronizedList(new ArrayList());
        List<TransformServerListing> listings = Collections.synchronizedList(new ArrayList());
        try {
            SlownessDetector.setEnabled((boolean)false);
            ExecutorService executor = Executors.newFixedThreadPool(5, (ThreadFactory)new NamedThreadFactory("Transform Discovery"));
            Set<String> found = Collections.synchronizedSet(new HashSet());
            for (TransformServerDetail ref : references) {
                String serverUrlString;
                TransformServerListing listing = new TransformServerListing(ref);
                FastURL serverUrl = ref.getV3Url();
                if (serverUrl == null) {
                    serverUrl = ref.getBaseUrl();
                }
                if ((serverUrlString = serverUrl.toString()) == null || !found.add(serverUrlString)) continue;
                executor.submit(() -> {
                    ProtocolVersion serverProtocolVersion = ref.getProtocolVersion();
                    TransformSourceFactory sourceFactory = (TransformSourceFactory)Lookup.getDefault().lookup(TransformSourceFactory.class);
                    TransformSource source = sourceFactory.get(serverProtocolVersion);
                    if (cb != null) {
                        cb.progress("Getting transforms for " + serverUrlString);
                    }
                    try {
                        TransformListInfo transforms = source.getTransforms(serverUrlString, TransformDiscoverySettings.getListTransformTimeout());
                        LOG.log(Level.FINE, "Discovered: {0}", transforms);
                        this.attachWebServices(listing, transforms);
                        this.attachTransformsEntitiesSets(listing, transforms, serverProtocolVersion);
                        TransformServerListingProvider latestProvider = null;
                        for (TransformServerListingProvider provider : TransformServerListingProvider.getAll()) {
                            if (!serverProtocolVersion.gte(provider.protocolVersion())) continue;
                            if (latestProvider == null) {
                                latestProvider = provider;
                                continue;
                            }
                            if (!provider.protocolVersion().gte(latestProvider.protocolVersion())) continue;
                            latestProvider = provider;
                        }
                        if (latestProvider != null) {
                            latestProvider.update(ref, listing);
                        }
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "Error in discovering transforms for {0} {1}", new Object[]{ref.getBaseUrl(), ex.getMessage()});
                        Exceptions.printStackTrace((Throwable)ex);
                        errors.add(ex);
                        listing.setFailed();
                    }
                });
                listings.add(listing);
            }
            executor.shutdown();
            try {
                executor.awaitTermination(1L, TimeUnit.HOURS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            SlownessDetector.setEnabled((boolean)true);
        }
        return new DiscoveryResult((Object[])listings.toArray(new TransformServerListing[listings.size()]), errors.toArray(new Exception[errors.size()]));
    }

    private void attachWebServices(TransformServerListing listing, TransformListInfo listInfo) {
        WebServiceTranslator translator = new WebServiceTranslator();
        List authenticators = listInfo.getOAuthAuthenticators();
        Map webServices = listing.getPublicWebServices();
        for (OAuthAuthenticatorInfo a : authenticators) {
            Map webService = translator.translate(a);
            webServices.putAll(webService);
        }
    }

    private void attachTransformsEntitiesSets(TransformServerListing listing, TransformListInfo listInfo, ProtocolVersion proto) {
        V2TransformSetRepository setRepository = new V2TransformSetRepository();
        TransformTranslator transformTranslator = TransformTranslatorFactory.getDefault().get(proto, setRepository.allSets());
        List transforms = listInfo.getTransforms();
        for (TransformInfo info : transforms) {
            try {
                listing.getTransforms().add(transformTranslator.translate(info, listing.getBaseUrl().getURL()));
                listing.getSets().addAll(setRepository.allSets());
                EntitySpecTranslator translator = EntitySpecTranslatorFactory.get(proto);
                listing.getEntities().addAll(translator.getEntities(info));
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

