/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.reporting.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.paterva.maltego.reporting.pdf.iTextStyle;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultiTextStyle
extends iTextStyle {
    private static final Logger LOGGER = Logger.getLogger(DefaultiTextStyle.class.getName());
    private static final Color _headerBackColor = new Color(15134704);
    private static final String _headerFontType = "Helvetica";
    private static final float _headerFontSize = 10.0f;
    private static final int _headerFontStyle = 0;
    private static final Color _headerFontColor = Color.DARK_GRAY;
    private static final int _headerPadding = 4;
    private static final int _headerBorder = 0;
    private static final Color _innerBackColor = new Color(0xF3F7F7);
    private static final String _innerFontType = "Helvetica";
    private static final float _innerFontSize = 9.0f;
    private static final int _innerFontStyle = 0;
    private static final Color _innerFontColor = Color.DARK_GRAY;
    private static final int _innerPadding = 3;
    private static final int _innerBorder = 0;

    public DefaultiTextStyle() {
        this.init();
    }

    private void init() {
        this.availableFonts = new TreeSet();
        this.baseFontList = new ArrayList();
        FontFactory.registerDirectories();
        Set registeredFonts = FontFactory.getRegisteredFonts();
        if (registeredFonts != null) {
            this.availableFonts = new TreeSet(registeredFonts);
            this.removeOtfFonts();
            DefaultFontMapper dfm = new DefaultFontMapper();
            for (String fontName : this.availableFonts) {
                if (StringUtilities.isNullOrEmpty((String)fontName)) continue;
                try {
                    BaseFont baseFont = this.getBaseFont(fontName);
                    if (baseFont == null) {
                        LOGGER.log(Level.FINE, "Font {0} does not exist", fontName);
                        continue;
                    }
                    if (this.baseFontList.contains(baseFont)) continue;
                    try {
                        Font javaFont = dfm.pdfToAwt(baseFont, 12);
                        if (javaFont == null) continue;
                        javaFont.deriveFont(13);
                        this.baseFontList.add(baseFont);
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "Failure when trying to load font {0}: {1}", new Object[]{fontName, ex});
                    }
                }
                catch (DocumentException | IOException e) {
                    LOGGER.log(Level.FINE, "Failure when trying to load font {0}: {1}", new Object[]{fontName, e});
                }
            }
        }
    }

    private void removeOtfFonts() {
        Map trueTypeFontsMap = null;
        try {
            FontFactoryImp fontImp = FontFactory.getFontImp();
            Field f = fontImp.getClass().getDeclaredField("trueTypeFonts");
            f.setAccessible(true);
            trueTypeFontsMap = (Map)f.get(fontImp);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            LOGGER.log(Level.WARNING, "Cannot get map of registered fonts");
        }
        if (trueTypeFontsMap != null) {
            Iterator iterator = this.availableFonts.iterator();
            while (iterator.hasNext()) {
                String path;
                Object obj;
                String name = (String)iterator.next();
                if (name == null || (obj = trueTypeFontsMap.get(name)) == null || !(path = (String)obj).toLowerCase().endsWith(".otf") && !path.toLowerCase().contains("notocoloremoji")) continue;
                iterator.remove();
            }
        }
    }

    private BaseFont getBaseFont(String fontName) throws DocumentException, IOException {
        BaseFont baseFont = null;
        try {
            com.lowagie.text.Font font = FontFactory.getFont((String)fontName, (String)"Identity-H", (boolean)true);
            if (font != null && (baseFont = font.getBaseFont()) != null) {
                baseFont.setSubset(true);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Cannot create BaseFont {0}: {1}", new Object[]{fontName, ex});
        }
        return baseFont;
    }

    @Override
    public Color getBackColor(boolean header) {
        return header ? _headerBackColor : _innerBackColor;
    }

    @Override
    public String getFontType(boolean header) {
        return header ? "Helvetica" : "Helvetica";
    }

    @Override
    public float getFontSize(boolean header) {
        return header ? 10.0f : 9.0f;
    }

    @Override
    public int getFontStyle(boolean header) {
        return header ? 0 : 0;
    }

    @Override
    public Color getFontColor(boolean header) {
        return header ? _headerFontColor : _innerFontColor;
    }

    @Override
    public int getPadding(boolean header) {
        return header ? 4 : 3;
    }

    @Override
    public int getBorder(boolean header) {
        return header ? 0 : 0;
    }
}

