/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.DisplayInformationProvider;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.PropertyBag;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.detailview.html.HtmlDetailViewSettings;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.PartTypeHelper;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.fonts.FontSizeRegistry;
import java.awt.Color;
import java.io.IOException;
import java.text.Bidi;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.apache.commons.text.StringEscapeUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

class HtmlDetailViewRenderer {
    public static final String TOGGLE_EVENT = "onclick";
    public static final String TOGGLE_CALL = "toggle(this)";
    public static final String TOGGLE_FUNC = HtmlDetailViewRenderer.getToggleFunction();
    private static HtmlDetailViewRenderer _default;
    private boolean _isLink;
    private String _entityHeader;
    private String _linkHeader;
    private String _style;
    private String _notes;
    private String _snippet;
    private String _snippetGroup;
    private String _photo;
    private String _photoGroup;
    private String _linkGroup;
    private String _linkIncoming;
    private String _linkOutgoing;
    private String _linkLeft;
    private String _linkRight;
    private String _endpoints;
    private String _properties;
    private String _property;
    private String _generatorGroup;
    private String _generator;
    private static final String[] LAF_NORMAL_COLORS;
    private static final String[] LAF_NORMAL_FONT_SIZES;

    public static HtmlDetailViewRenderer getDefault() {
        if (_default == null) {
            _default = new HtmlDetailViewRenderer();
        }
        return _default;
    }

    private HtmlDetailViewRenderer() {
    }

    public String renderEmpty() {
        EntityRegistry registry = EntityRegistry.getDefault();
        GenericEntity entity = new GenericEntity(EntityID.create(), "maltego.Unknown");
        String html = "<!DOCTYPE HTML><html>" + this.style(null) + "<body>" + this.formatEntityHeader(registry, (MaltegoEntity)entity, null) + this.formatPropertyGroup((TypedPropertyBag)entity) + this.formatPhotos(entity.getID(), Collections.EMPTY_LIST) + this.formatNotes((MaltegoPart)entity) + "</body></html>";
        return html;
    }

    public String render(GraphPart graphPart) throws GraphStoreException {
        String html;
        try {
            GraphID graphID = graphPart.getGraphID();
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            GraphModelViewMappings mappings = view.getModelViewMappings();
            boolean isEntity = graphPart instanceof GraphEntity;
            if (isEntity) {
                EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
                EntityID entityID = (EntityID)graphPart.getID();
                if (mappings.isOnlyViewEntity(entityID)) {
                    html = this.renderCollection(graphID, entityID, registry);
                } else {
                    MaltegoEntity entity = view.getModel().getGraphDataStore().getDataStoreReader().getEntity(entityID);
                    html = this.render(graphID, (MaltegoPart)entity, (SpecRegistry)registry);
                }
            } else {
                LinkRegistry registry = LinkRegistry.forGraphID((GraphID)graphID);
                LinkID linkID = (LinkID)graphPart.getID();
                if (mappings.isOnlyViewLink(linkID)) {
                    html = this.renderCollection(graphID, linkID, registry);
                } else {
                    MaltegoLink link = view.getModel().getGraphDataStore().getDataStoreReader().getLink(linkID);
                    html = this.render(graphID, (MaltegoPart)link, (SpecRegistry)registry);
                }
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            html = "<!DOCTYPE HTML><html>Something went wrong...</html>";
        }
        return html;
    }

    private String renderCollection(GraphID graphID, EntityID entityID, EntityRegistry registry) throws GraphStoreException {
        return "<!DOCTYPE HTML><html>" + this.formatStyle(this.style("detail-view-normal-headinggroup-background-color")) + "<body>" + this.formatEntityCollectionHeader(graphID, entityID, registry) + "</body></html>";
    }

    private String renderCollection(GraphID graphID, LinkID linkID, LinkRegistry registry) throws GraphStoreException {
        return "<!DOCTYPE HTML><html>" + this.formatStyle(this.style("detail-view-normal-headinggroup-background-color")) + "<body>" + this.formatLinkCollectionHeader(graphID, linkID, registry) + "</body></html>";
    }

    private String render(GraphID graphID, MaltegoPart part, SpecRegistry registry) throws GraphStoreException {
        String html;
        TypeSpec spec = registry.get(part.getTypeName());
        this._isLink = part instanceof MaltegoLink;
        if (!this._isLink) {
            MaltegoEntity entity = (MaltegoEntity)part;
            html = "<!DOCTYPE HTML><html>" + this.formatStyle(this.style(null)) + "<body>" + this.formatEntityHeader((EntityRegistry)registry, entity, spec) + this.formatPropertyGroup((TypedPropertyBag)part) + this.formatPhotos(part.getID(), AttachmentUtils.getImageAttachments((PropertyBag)part)) + this.formatLinks(graphID, entity) + this.formatNotes(part) + this.formatSnippets((DisplayInformationProvider)part) + this.formatGeneratorDetails(graphID, entity) + "</body></html>";
        } else {
            MaltegoLink link = (MaltegoLink)part;
            html = "<!DOCTYPE HTML><html>" + this.formatStyle(this.style(null)) + "<body>" + this.formatLinkHeader(link, spec) + this.formatPropertyGroup((TypedPropertyBag)part) + this.formatPhotos(part.getID(), AttachmentUtils.getImageAttachments((PropertyBag)part)) + this.formatEndpoints(graphID, (LinkID)link.getID()) + this.formatNotes(part) + this.formatSnippets((DisplayInformationProvider)part) + "</body></html>";
        }
        return html;
    }

    private static String getToggleFunction() {
        StringBuilder sb = new StringBuilder();
        sb.append("function toggle(source){");
        sb.append("var div=source.parentNode.parentNode.childNodes.item(3);");
        sb.append("if(div.style.display==\"block\"){");
        sb.append("  div.style.display=\"none\";");
        sb.append("}else{");
        sb.append("  div.style.display=\"block\";");
        sb.append("}");
        sb.append("var button=source.firstChild;");
        sb.append("if(button.innerText=='\u2013'){");
        sb.append("  button.innerText=\"+\";");
        sb.append("}else{");
        sb.append("  button.innerText='\u2013';");
        sb.append("}");
        sb.append("}");
        return sb.toString();
    }

    private String entityHeader() {
        if (this._entityHeader == null) {
            try {
                this._entityHeader = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLEntityHeader");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._entityHeader;
    }

    private String linkHeader() {
        if (this._linkHeader == null) {
            try {
                this._linkHeader = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkHeader");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._linkHeader;
    }

    private String notes() {
        if (this._notes == null) {
            try {
                this._notes = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLNotes");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._notes;
    }

    private String style(String customBg) {
        String[] laf_colours = LAF_NORMAL_COLORS;
        String[] laf_font_sizes = LAF_NORMAL_FONT_SIZES;
        if (this._style == null) {
            try {
                this._style = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLStyle");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        UIDefaults LAF = UIManager.getLookAndFeelDefaults();
        String lafStyle = this._style;
        for (String color : laf_colours) {
            Color lafColor = LAF.getColor(color);
            if (customBg != null && "detail-view-empty-bg".equals(color)) {
                lafColor = LAF.getColor(customBg);
            }
            lafStyle = lafStyle.replace(color, String.format("#%02x%02x%02x", lafColor.getRed(), lafColor.getGreen(), lafColor.getBlue()));
        }
        int lafFontSizes = FontSizeRegistry.getDefault().getFontSize("detailViewFontSize");
        for (String fontSize : laf_font_sizes) {
            lafStyle = lafStyle.replace(fontSize, lafFontSizes + "px");
        }
        return lafStyle;
    }

    private String snippetGroup() {
        if (this._snippetGroup == null) {
            try {
                this._snippetGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLSnippetGroup");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._snippetGroup;
    }

    private String snippet() {
        if (this._snippet == null) {
            try {
                this._snippet = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLSnippet");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._snippet;
    }

    private String photoGroup() {
        if (this._photoGroup == null) {
            try {
                this._photoGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLPhotoGroup");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._photoGroup;
    }

    private String photo() {
        if (this._photo == null) {
            try {
                this._photo = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLPhoto");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._photo;
    }

    private String linkGroup() {
        if (this._linkGroup == null) {
            try {
                this._linkGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkGroup");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._linkGroup;
    }

    private String linkIncoming() {
        if (this._linkIncoming == null) {
            try {
                this._linkIncoming = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkIncoming");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._linkIncoming;
    }

    private String linkOutoging() {
        if (this._linkOutgoing == null) {
            try {
                this._linkOutgoing = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkOutgoing");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._linkOutgoing;
    }

    private String linkLeft() {
        if (this._linkLeft == null) {
            try {
                this._linkLeft = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkLeft");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._linkLeft;
    }

    private String linkRight() {
        if (this._linkRight == null) {
            try {
                this._linkRight = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLLinkRight");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._linkRight;
    }

    private String endpoints() {
        if (this._endpoints == null) {
            try {
                this._endpoints = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLEndpoints");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._endpoints;
    }

    private String properties() {
        if (this._properties == null) {
            try {
                this._properties = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLProperties");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._properties;
    }

    private String property() {
        if (this._property == null) {
            try {
                this._property = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLProperty");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._property;
    }

    private String generatorGroup() {
        if (this._generatorGroup == null) {
            try {
                this._generatorGroup = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLGeneratorGroup");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._generatorGroup;
    }

    private String generator() {
        if (this._generator == null) {
            try {
                this._generator = HtmlDetailViewRenderer.load("Maltego/DetailView/HTMLGenerator");
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this._generator;
    }

    private static String load(String path) throws IOException {
        FileObject file = FileUtil.getConfigRoot().getFileObject(path);
        if (file != null) {
            return file.asText();
        }
        return null;
    }

    private String formatStyle(String style) {
        return this.safeReplace(style, "//${toggle-function}", TOGGLE_FUNC);
    }

    private String formatEntityHeader(EntityRegistry registry, MaltegoEntity entity, TypeSpec spec) {
        String displayName;
        String type;
        String displayType = type = entity.getTypeName();
        if (spec != null) {
            displayType = spec.getDisplayName();
        }
        if (StringUtilities.isNullOrEmpty((String)(displayName = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)entity)))) {
            displayName = "<empty>";
        }
        String header = this.safeReplace(this.entityHeader(), "${entity-display-value}", HtmlDetailViewRenderer.htmlBidiText(displayName));
        String entityIDString = ((EntityID)entity.getID()).toString();
        header = this.safeReplace(header, "${entity-id}", HtmlDetailViewRenderer.htmlBidiText(entityIDString));
        header = this.safeReplace(header, "${entity-pin-id}", HtmlDetailViewRenderer.htmlBidiText(entityIDString));
        header = this.safeReplace(header, "${entity-collection-pin-id}", HtmlDetailViewRenderer.htmlBidiText(entityIDString));
        header = this.safeReplace(header, "${entity-type}", HtmlDetailViewRenderer.htmlBidiText(type));
        header = this.safeReplace(header, "${entity-display-type}", HtmlDetailViewRenderer.htmlBidiText(displayType));
        return header;
    }

    private String formatEntityCollectionHeader(GraphID graphID, EntityID entityID, EntityRegistry registry) throws GraphStoreException {
        String type = PartTypeHelper.getType((GraphID)graphID, (EntityID)entityID);
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(type);
        String displayType = type;
        if (spec != null) {
            displayType = spec.getDisplayName();
        }
        int size = CollectionNodeUtils.getModelEntityCount((GraphID)graphID, (EntityID)entityID);
        String displayName = size + " " + displayType + " entities";
        String header = this.safeReplace(this.entityHeader(), "${entity-display-value}", HtmlDetailViewRenderer.htmlBidiText(displayName));
        String entityIDString = entityID.toString();
        header = this.safeReplace(header, "${entity-id}", HtmlDetailViewRenderer.htmlBidiText(entityIDString));
        header = this.safeReplace(header, "${entity-pin-id}", HtmlDetailViewRenderer.htmlBidiText(entityIDString));
        header = this.safeReplace(header, "${entity-collection-pin-id}", HtmlDetailViewRenderer.htmlBidiText(entityIDString));
        header = this.safeReplace(header, "${entity-type}", HtmlDetailViewRenderer.htmlBidiText(type));
        header = this.safeReplace(header, "${entity-display-type}", HtmlDetailViewRenderer.htmlBidiText(displayType));
        return header;
    }

    private String formatLinkHeader(MaltegoLink link, TypeSpec spec) {
        String displayName;
        String type = "";
        String displayType = link.getTypeName();
        if (spec != null) {
            displayType = spec.getDisplayName();
            DisplayDescriptor nameDescriptor = spec.getProperties().get("maltego.link.transform.name");
            if (nameDescriptor != null) {
                type = link.getValue((PropertyDescriptor)nameDescriptor).toString();
            }
        }
        if (StringUtilities.isNullOrEmpty((String)(displayName = InheritanceHelper.getDisplayString((SpecRegistry)LinkRegistry.getDefault(), (TypedPropertyBag)link)))) {
            displayName = "<empty>";
        }
        String header = this.safeReplace(this.linkHeader(), "${link-display-value}", HtmlDetailViewRenderer.htmlBidiText(displayName));
        header = this.safeReplace(header, "${link-id}", HtmlDetailViewRenderer.htmlBidiText(((LinkID)link.getID()).toString()));
        header = this.safeReplace(header, "${link-type}", HtmlDetailViewRenderer.htmlBidiText(type));
        header = this.safeReplace(header, "${link-display-type}", HtmlDetailViewRenderer.htmlBidiText(displayType));
        return header;
    }

    private String formatLinkCollectionHeader(GraphID graphID, LinkID linkID, LinkRegistry registry) throws GraphStoreException {
        String type = "maltego.link";
        String displayType = "Link";
        int size = CollectionNodeUtils.getModelLinkCount((GraphID)graphID, (LinkID)linkID);
        String displayName = size + " Links";
        String header = this.safeReplace(this.linkHeader(), "${link-display-value}", HtmlDetailViewRenderer.htmlBidiText(displayName));
        header = this.safeReplace(header, "${link-id}", HtmlDetailViewRenderer.htmlBidiText(linkID.toString()));
        header = this.safeReplace(header, "${link-type}", HtmlDetailViewRenderer.htmlBidiText(type));
        header = this.safeReplace(header, "${link-display-type}", HtmlDetailViewRenderer.htmlBidiText(displayType));
        return header;
    }

    private String formatGeneratorDetails(GraphID graphID, MaltegoEntity entity) throws GraphStoreException {
        String generatorDetails = "";
        if (entity != null) {
            HashSet<LinkID> linkIDs;
            EntityID entityID = (EntityID)entity.getID();
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            int maxLinks = 100;
            Set incoming = structureReader.getIncoming(entityID);
            if (incoming.size() <= 100) {
                linkIDs = new HashSet<LinkID>(incoming);
                Set outgoing = structureReader.getOutgoing(entityID);
                if (linkIDs.size() + outgoing.size() <= 100) {
                    linkIDs.addAll(outgoing);
                } else {
                    Iterator iterator = outgoing.iterator();
                    while (iterator.hasNext()) {
                        LinkID linkID = (LinkID)iterator.next();
                        linkIDs.add(linkID);
                        if (linkIDs.size() < 100) continue;
                        break;
                    }
                }
            } else {
                linkIDs = new HashSet(100);
                for (LinkID linkID : incoming) {
                    linkIDs.add(linkID);
                    if (linkIDs.size() < 100) continue;
                    break;
                }
            }
            if (!linkIDs.isEmpty()) {
                EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
                StringBuilder content = new StringBuilder();
                Set links = GraphStoreHelper.getMaltegoLinks((GraphID)graphID, linkIDs);
                HashMap<EntityID, GeneratorData> generatorDatas = new HashMap<EntityID, GeneratorData>();
                for (MaltegoLink link : links) {
                    String runDate;
                    String transform;
                    LinkID linkID = (LinkID)link.getID();
                    boolean isIncoming = incoming.contains(linkID);
                    boolean isReversed = Boolean.TRUE.equals(link.isReversed());
                    if ((!isIncoming || isReversed) && (isIncoming || !isReversed) || (transform = this.getValueString((MaltegoPart)link, "maltego.link.transform.display-name")) == null || (runDate = this.getValueString((MaltegoPart)link, "maltego.link.transform.run-date")) == null) continue;
                    EntityID sourceID = isIncoming ? structureReader.getSource(linkID) : structureReader.getTarget(linkID);
                    generatorDatas.put(sourceID, new GeneratorData(transform, runDate));
                }
                Map entities = GraphStoreHelper.getEntities((GraphID)graphID, generatorDatas.keySet());
                for (Map.Entry entry : generatorDatas.entrySet()) {
                    EntityID sourceID = (EntityID)entry.getKey();
                    GeneratorData generatorData = (GeneratorData)entry.getValue();
                    String section = this.generator();
                    MaltegoEntity source = (MaltegoEntity)entities.get(sourceID);
                    section = this.safeReplace(section, "${generator-source}", this.getEntityName(registry, source));
                    section = this.safeReplace(section, "${generator-source-type}", "(" + this.getEntityType(registry, source) + ")");
                    section = this.safeReplace(section, "${generator-transform}", generatorData.getTransform());
                    section = this.safeReplace(section, "${generator-date}", generatorData.getRunDate());
                    content.append(section);
                }
                if (content.length() > 0) {
                    generatorDetails = this.safeReplace(this.generatorGroup(), "${expand-value}", HtmlDetailViewSettings.getDisplayValue("generatorBox"));
                    generatorDetails = this.safeReplace(generatorDetails, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("generatorBox"));
                    generatorDetails = this.safeReplace(generatorDetails, "${content}", content.toString());
                    generatorDetails = this.safeReplace(generatorDetails, "${generator-title}", "Generator detail");
                }
            }
        }
        return generatorDetails;
    }

    private String getValueString(MaltegoPart part, String property) {
        Object value;
        String valueStr = null;
        PropertyDescriptorCollection properties = part.getProperties();
        PropertyDescriptor pd = properties.get(property);
        if (pd != null && (value = part.getValue(pd)) != null) {
            valueStr = Converter.convertTo((Object)value, (Class)pd.getType());
        }
        return valueStr;
    }

    private String formatPropertyGroup(TypedPropertyBag propertyBag) {
        StringBuilder sb = new StringBuilder();
        FileObject tables = FileUtil.getConfigFile((String)"Maltego/DetailViewPropertyGroup");
        if (tables != null) {
            int groupNum = 1;
            for (FileObject group : FileUtil.getOrder(Arrays.asList(tables.getChildren()), (boolean)false)) {
                String content;
                String groupName = group.getName();
                List children = FileUtil.getOrder(Arrays.asList(group.getChildren()), (boolean)true);
                if (children == null || children.size() <= 0 || StringUtilities.isNullOrEmpty((String)(content = this.formatProperties(children, propertyBag)))) continue;
                String properties = this.safeReplace(this.properties(), "${properties-title}", HtmlDetailViewRenderer.htmlBidiText(groupName));
                properties = this.safeReplace(properties, "${group-number}", Integer.toString(groupNum));
                properties = this.safeReplace(properties, "${expand-value}", HtmlDetailViewSettings.getDisplayValue("propertyBox" + groupNum));
                properties = this.safeReplace(properties, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("propertyBox" + groupNum));
                properties = this.safeReplace(properties, "${content}", content);
                sb.append(properties);
            }
        }
        return sb.toString();
    }

    private String formatProperties(List<FileObject> children, TypedPropertyBag propertyBag) {
        StringBuilder contentBuilder = new StringBuilder();
        for (FileObject child : children) {
            String valueStr;
            TypeDescriptor type;
            Object value;
            String propertyName = (String)child.getAttribute("property");
            PropertyDescriptor pd = propertyBag.getProperties().get(propertyName);
            if (pd == null || (value = propertyBag.getValue(pd)) == null || (type = TypeRegistry.getDefault().getType(pd.getType())) == null || StringUtilities.isNullOrEmpty((String)(valueStr = type.convert(value)))) continue;
            String property = this.property();
            property = this.safeReplace(property, "${property-display-name}", pd.getDisplayName());
            property = this.safeReplace(property, "${property-value}", valueStr);
            contentBuilder.append(property);
        }
        return contentBuilder.toString();
    }

    private String formatSnippets(DisplayInformationProvider infoProvider) {
        StringBuilder result = new StringBuilder();
        DisplayInformationCollection infoCollection = infoProvider.getDisplayInformation();
        if (infoCollection != null && infoCollection.size() > 0) {
            LinkedHashMap<String, DisplayInformationCollection> map = new LinkedHashMap<String, DisplayInformationCollection>();
            for (DisplayInformation info : infoCollection) {
                DisplayInformationCollection subList = (DisplayInformationCollection)map.get(info.getName());
                if (subList == null) {
                    subList = new DisplayInformationCollection();
                    map.put(info.getName(), subList);
                }
                subList.add(info);
            }
            int i = 1;
            for (String name : map.keySet()) {
                String group = this.formatSnippetGroup(name, (DisplayInformationCollection)map.get(name), String.valueOf(i));
                result.append(group);
                ++i;
            }
        }
        return result.toString();
    }

    private String formatSnippetGroup(String name, DisplayInformationCollection infoList, String groupNumber) {
        String group = this.safeReplace(this.snippetGroup(), "${snippet-title}", name);
        group = this.safeReplace(group, "${group-number}", groupNumber);
        group = this.safeReplace(group, "${expand-value}", HtmlDetailViewSettings.getDisplayValue("snippetBox" + groupNumber));
        group = this.safeReplace(group, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("snippetBox" + groupNumber));
        StringBuilder content = new StringBuilder();
        for (DisplayInformation info : infoList) {
            String value = this.safeReplace(this.snippet(), "${snippet-body}", info != null ? info.getValue() : "");
            content.append(value);
        }
        return this.safeReplace(group, "${content}", content.toString());
    }

    private String formatNotes(MaltegoPart part) {
        String noteValue = part.getNotes();
        String notes = "";
        if (!StringUtilities.isNullOrEmpty((String)noteValue)) {
            noteValue = this.safeReplace(noteValue, "\n", "<br>");
            noteValue = HtmlUtils.addHrefs((String)noteValue);
            notes = this.safeReplace(this.notes(), "${notes}", noteValue);
            notes = this.safeReplace(notes, "${expand-value}", HtmlDetailViewSettings.getDisplayValue("noteBox"));
            notes = this.safeReplace(notes, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("noteBox"));
        }
        return notes;
    }

    private String formatPhotos(Guid partID, List<Attachment> atts) {
        String group = "";
        if (!atts.isEmpty()) {
            group = this.safeReplace(this.photoGroup(), "${expand-value}", HtmlDetailViewSettings.getDisplayValue("photoBox"));
            group = this.safeReplace(group, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("photoBox"));
            StringBuilder content = new StringBuilder();
            for (Attachment att : atts) {
                try {
                    String value = this.safeReplace(this.photo(), "${part-id}", HtmlDetailViewRenderer.htmlBidiText(partID.toString()));
                    value = this.safeReplace(value, "${att-id}", Integer.toString(att.getId()));
                    content.append(value);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            group = this.safeReplace(group, "${content}", content.toString());
        }
        return group;
    }

    private String formatLinks(GraphID graphID, MaltegoEntity entity) throws GraphStoreException {
        EntityID entityID;
        GraphStore graphStore;
        GraphStructureReader structureReader;
        String group = "";
        if (entity != null && (structureReader = (graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID)).getGraphStructureStore().getStructureReader()).getLinkCount(entityID = (EntityID)entity.getID()) > 0) {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            group = this.safeReplace(this.linkGroup(), "${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkBox"));
            group = this.safeReplace(group, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkBox"));
            StringBuilder groupContent = new StringBuilder();
            if (structureReader.getIncomingLinkCount(entityID) > 0) {
                String incoming = this.safeReplace(this.linkIncoming(), "${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkInBox"));
                incoming = this.safeReplace(incoming, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkInBox"));
                incoming = this.safeReplace(incoming, "${content}", this.formatSubLinks(registry, graphID, structureReader.getParents(entityID)));
                groupContent.append(incoming);
            }
            if (structureReader.getOutgoingLinkCount(entityID) > 0) {
                String outgoing = this.safeReplace(this.linkOutoging(), "${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkOutBox"));
                outgoing = this.safeReplace(outgoing, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkOutBox"));
                outgoing = this.safeReplace(outgoing, "${content}", this.formatSubLinks(registry, graphID, structureReader.getChildren(entityID)));
                groupContent.append(outgoing);
            }
            group = this.safeReplace(group, "${content}", groupContent.toString());
        }
        return group;
    }

    private String formatSubLinks(EntityRegistry registry, GraphID graphID, Set<EntityID> entityIDs) {
        boolean left = true;
        StringBuilder result = new StringBuilder();
        int maxEntities = 100;
        if (entityIDs.size() > 100) {
            HashSet<EntityID> tempEntityIDs = new HashSet<EntityID>(100);
            for (EntityID entityID : entityIDs) {
                tempEntityIDs.add(entityID);
                if (tempEntityIDs.size() != 100) continue;
                break;
            }
            entityIDs = tempEntityIDs;
        }
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, entityIDs);
        for (MaltegoEntity entity : entities) {
            String template = left ? this.linkLeft() : this.linkRight();
            String value = this.safeReplace(template, "${link-reference}", this.getEntityReference(entity));
            value = this.safeReplace(value, "${link-title}", this.getEntityName(registry, entity));
            result.append(value);
            left = !left;
        }
        if (left) {
            String empty = this.safeReplace(this.linkRight(), "${link-reference}", "");
            empty = this.safeReplace(empty, "${link-title}", "");
            result.append(empty);
        }
        return result.toString();
    }

    private String getEntityReference(MaltegoEntity entity) {
        return "http://localhost:1/maltego/navigateTo/" + entity.getID();
    }

    private String getEntityName(EntityRegistry registry, MaltegoEntity entity) {
        String entityValue = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)entity);
        if (StringUtilities.isNullOrEmpty((String)entityValue)) {
            entityValue = "<null>";
        }
        return entityValue;
    }

    private String getEntityType(EntityRegistry registry, MaltegoEntity entity) {
        MaltegoEntitySpec spec;
        String type = entity.getTypeName();
        if (registry != null && (spec = (MaltegoEntitySpec)registry.get(type)) != null) {
            type = spec.getDisplayName();
        }
        return type;
    }

    private String formatEndpoints(GraphID graphID, LinkID linkID) throws GraphStoreException {
        String group = "";
        if (linkID != null) {
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            group = this.safeReplace(this.endpoints(), "${expand-value}", HtmlDetailViewSettings.getDisplayValue("linkBox"));
            group = this.safeReplace(group, "${expand-sign}", HtmlDetailViewSettings.getDisplaySign("linkBox"));
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            EntityID sourceID = structureReader.getSource(linkID);
            MaltegoEntity sourceEntity = dataReader.getEntity(sourceID);
            group = this.safeReplace(group, "${source-reference}", this.getEntityReference(sourceEntity));
            group = this.safeReplace(group, "${source-id}", ((EntityID)sourceEntity.getID()).toString());
            group = this.safeReplace(group, "${source-title}", this.getEntityName(registry, sourceEntity));
            EntityID targetID = structureReader.getTarget(linkID);
            MaltegoEntity destEntity = dataReader.getEntity(targetID);
            group = this.safeReplace(group, "${target-reference}", this.getEntityReference(destEntity));
            group = this.safeReplace(group, "${target-id}", ((EntityID)destEntity.getID()).toString());
            group = this.safeReplace(group, "${target-title}", this.getEntityName(registry, destEntity));
        }
        return group;
    }

    private String safeReplace(String text, String toReplace, String replaceWith) {
        return text.replace(toReplace, replaceWith != null ? replaceWith : "");
    }

    private static String htmlBidiText(String text) {
        Bidi bidi = new Bidi(text, -2);
        if (bidi.isLeftToRight()) {
            String escaped = StringEscapeUtils.escapeHtml4((String)text);
            return StringUtilities.lang3EscapeHtml4ToLang2EscapeHtml((String)escaped);
        }
        if (bidi.isRightToLeft()) {
            String escaped = StringEscapeUtils.escapeHtml4((String)HtmlDetailViewRenderer.reverseRTLPhrase(text));
            return StringUtilities.lang3EscapeHtml4ToLang2EscapeHtml((String)escaped);
        }
        String special = " ~!@#$%^&*()_+=-0987654321`\\][';,./|}{:\"?><";
        String LRE = "\u202a";
        String RLE = "\u202b";
        String LRO = "\u202d";
        String RLO = "\u202e";
        String PDF = "\u202c";
        String bidiText = text.replace("\u202a", "").replace("\u202b", "").replace("\u202d", "").replace("\u202e", "").replace("\u202c", "");
        if (!bidiText.equals(text)) {
            bidi = new Bidi(bidiText, -2);
        }
        int runCount = bidi.getRunCount();
        StringBuilder builder = new StringBuilder(bidiText.length() + runCount + 1);
        for (int run = 0; run < runCount; ++run) {
            int runLevel = bidi.getRunLevel(run);
            boolean rtl = runLevel % 2 != 0;
            int runStart = bidi.getRunStart(run);
            int runLimit = bidi.getRunLimit(run);
            String extract = bidiText.substring(runStart, runLimit);
            if (rtl) {
                int end;
                for (end = extract.length(); end > 0 && " ~!@#$%^&*()_+=-0987654321`\\][';,./|}{:\"?><".indexOf(extract.charAt(end - 1)) >= 0; --end) {
                }
                if (end > 0 && end < extract.length()) {
                    extract = extract.substring(0, end);
                    bidiText = bidiText.substring(runStart + end);
                    bidi = new Bidi(bidiText, -2);
                    runCount = bidi.getRunCount();
                    run = -1;
                }
                extract = HtmlDetailViewRenderer.reverseRTLPhrase(extract);
            }
            builder.append(extract);
        }
        String escaped = StringEscapeUtils.escapeHtml4((String)builder.toString());
        return StringUtilities.lang3EscapeHtml4ToLang2EscapeHtml((String)escaped);
    }

    public static String reverseRTLPhrase(String phrase) {
        String[] words = phrase.split(" ");
        StringBuilder builder = new StringBuilder();
        for (int reverse = words.length - 1; reverse >= 0; --reverse) {
            builder.append(words[reverse]);
            builder.append(" ");
        }
        return builder.toString();
    }

    static {
        LAF_NORMAL_COLORS = new String[]{"detail-view-empty-bg", "detail-view-normal-body-color", "detail-view-normal-a-color", "detail-view-normal-a-hover-color", "detail-view-normal-headinggroup-background-color", "detail-view-normal-headinggroup-imggroup-background-color", "detail-view-normal-headinggroup-title-color", "detail-view-normal-headinggroup-subtitle-color", "detail-view-normal-headinggroup-entitycontent-color", "detail-view-normal-headinggroup-linkcontent-color", "detail-view-normal-photogroup-innerbox-background-color", "detail-view-normal-photogroup-title-background-color", "detail-view-normal-propertygroup-title-background-color", "detail-view-normal-propertygroup-innerbox-background-color", "detail-view-normal-propertygroup-innerbox-border-color", "detail-view-normal-propertygroup-content-border-color", "detail-view-normal-propertygroup-table-background-color", "detail-view-normal-propertygroup-td-background-color", "detail-view-normal-linkgroup-title-background-color", "detail-view-normal-linkgroup-innerbox-background-color", "detail-view-normal-linkgroup-innerbox-border-color", "detail-view-normal-linkgroup-subtitle-color", "detail-view-normal-linkgroup-content-border-color", "detail-view-normal-notegroup-title-color", "detail-view-normal-notegroup-title-background-color", "detail-view-normal-notegroup-innerbox-background-color", "detail-view-normal-notegroup-innerbox-border-color", "detail-view-normal-notegroup-content-border-color", "detail-view-normal-snippetgroup-title-background-color", "detail-view-normal-snippetgroup-innerbox-background-color", "detail-view-normal-snippetgroup-innerbox-border-color", "detail-view-normal-snippetgroup-content-border-color", "detail-view-normal-snippetgroup-table-background-color", "detail-view-normal-snippetgroup-td-background-color", "detail-view-normal-td-one-color", "detail-view-normal-td-one-background-color", "detail-view-normal-td-two-color", "detail-view-normal-td-three-color", "detail-view-normal-td-three-background-color", "detail-view-normal-td-value-color"};
        LAF_NORMAL_FONT_SIZES = new String[]{"detail-view-normal-body-font-size"};
    }

    private static class GeneratorData {
        private final String _transform;
        private final String _runDate;

        public GeneratorData(String transform, String runDate) {
            this._transform = transform;
            this._runDate = runDate;
        }

        public String getTransform() {
            return this._transform;
        }

        public String getRunDate() {
            return this._runDate;
        }
    }
}

