/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.update.wizard;

import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import com.paterva.maltego.welcome.update.UpdateUtils;
import com.paterva.maltego.welcome.update.wizard.DetectFailedControl;
import com.paterva.maltego.welcome.update.wizard.UpdateInfoControl;
import com.paterva.maltego.welcome.update.wizard.UpdateWizardConstants;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;

public class UpdateDetectController
extends PassFailProgressController<Collection<UpdateElement>, UpdateInfoControl, DetectFailedControl>
implements WizardNavigationSupport {
    private static final Logger LOG = Logger.getLogger(UpdateDetectController.class.getName());
    private final ChangeSupport _navigationSupport = new ChangeSupport((Object)this);

    public UpdateDetectController() {
        this.setName("Detect updates");
        this.setDescription("Updates to Maltego have been found. Keeping Maltego updated ensures that you have access to the latest features and bug fixes.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Update.png".replace(".png", "48.png")));
    }

    protected UpdateInfoControl createPassComponent() {
        return new UpdateInfoControl();
    }

    protected DetectFailedControl createFailComponent() {
        return new DetectFailedControl();
    }

    protected void pass(WizardDescriptor descriptor, UpdateInfoControl component, Collection<UpdateElement> updateElements) {
        descriptor.putProperty(UpdateWizardConstants.PROP_UPDATE_ELEMENTS, updateElements);
        descriptor.putProperty(UpdateWizardConstants.PROP_UPDATES_FOUND, (Object)Boolean.TRUE);
        component.setUpdateCount(updateElements.size());
        component.setDownloadSize(UpdateUtils.getDownloadSize(updateElements));
    }

    protected void fail(DetectFailedControl component, Exception e) {
        this.getDescriptor().putProperty(UpdateWizardConstants.PROP_UPDATES_FOUND, (Object)Boolean.FALSE);
        boolean noUpdates = e instanceof NoUpdatesException;
        component.setNoUpdates(noUpdates);
        if (!noUpdates) {
            component.setError(e.getMessage());
        }
    }

    protected Collection<UpdateElement> doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        Collection<UpdateElement> updateElements = null;
        try {
            UpdateUtils.debugSleep();
            UpdateUnitProviderFactory.getDefault().refreshProviders(handle, true);
            updateElements = UpdateUtils.getAvailableUpdates();
            if (updateElements.isEmpty()) {
                throw new NoUpdatesException();
            }
            UpdateUtils.debugSleep();
        }
        catch (Exception ex) {
            String msg = ex.getMessage();
            if (msg != null && msg.contains("updates.xml")) {
                LOG.warning(msg);
                throw new NoUpdatesException();
            }
            throw ex;
        }
        return updateElements;
    }

    protected String getFailureMessage() {
        return null;
    }

    protected void fireNavigationChanged() {
        super.fireNavigationChanged();
        this._navigationSupport.fireChange();
    }

    public void addNavigationListener(ChangeListener listener) {
        this._navigationSupport.addChangeListener(listener);
    }

    public void removeNavigationListener(ChangeListener listener) {
        this._navigationSupport.removeChangeListener(listener);
    }

    private static class NoUpdatesException
    extends Exception {
        public NoUpdatesException() {
            super("No updates were found.");
        }

        @Override
        public void printStackTrace() {
            System.err.println(this.getMessage());
        }
    }
}

