/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.ball;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeLabel;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerConstants;
import com.paterva.maltego.ui.graph.view2d.EntitySloppyPainter;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.painter.AbstractEntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityLabels;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPaintContext;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.view.ball.BallCustomizableView;
import com.paterva.maltego.view.ball.BallPaintUtils;
import com.paterva.maltego.view.ball.BallPainterToolbarPanel;
import com.paterva.maltego.view.ball.BallProperties;
import com.paterva.maltego.view.ball.BallViewSloppyPainter;
import com.paterva.maltego.view.ball.RoundHotSpotPainter;
import com.paterva.maltego.view.customization.api.CustomizableView;
import com.paterva.maltego.view.customization.api.CustomizableViewRegistry;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.openide.util.NbPreferences;
import yguard.A.A.Y;
import yguard.A.J.BA;
import yguard.A.J.gB;

public class BallEntityPainter
extends AbstractEntityPainter {
    private static final Logger LOG = Logger.getLogger(BallEntityPainter.class.getName());
    private static final Color BALL_VIEW_TEXT_COLOR = UIManager.getLookAndFeelDefaults().getColor("graph-view-ball-text-color");
    static final String NAME = "BallView";
    private static boolean _paintAttachmentsOverlay;
    private static long _lastUpdate;
    private final EntitySloppyPainter _sloppyPainter = new BallViewSloppyPainter();
    private final RoundHotSpotPainter _hotSpotPainter = new RoundHotSpotPainter();

    public BallEntityPainter() {
        super(NAME, "Bubble View", null, 100);
    }

    public boolean isCollectionNodeEditorEnabled() {
        return false;
    }

    public JComponent createToolbarComponent(GraphID graphID) {
        BallCustomizableView view = new BallCustomizableView(graphID);
        CustomizableViewRegistry.getDefault().putView(graphID, (CustomizableView)view);
        return new BallPainterToolbarPanel((EntityPainter)this, graphID, view);
    }

    public void paintSloppy(Graphics2D g2D, LightweightEntityRealizer realizer, boolean paintAnimations) throws Exception {
        this._sloppyPainter.setPaintAnimations(paintAnimations);
        this._sloppyPainter.paintSloppy((BA)realizer, g2D);
    }

    public void paint(Graphics2D g2D, EntityPaintContext ctx) throws Exception {
        LightweightEntityRealizer nr = ctx.getRealizer();
        Y node = nr.getNode();
        double ballSize = BallProperties.getBallSize(node);
        double y = nr.getY();
        Color c = BallProperties.getBallColor(node);
        if (c == null) {
            c = ctx.getTypeColor();
        }
        LOG.log(Level.FINE, "ballSize={0}", ballSize);
        BallPaintUtils.paintBall((BA)nr, g2D, c, ballSize);
        if (!ctx.isCollectionNode()) {
            if (BALL_VIEW_TEXT_COLOR == null) {
                nr.getLabel().setTextColor(c.darker().darker());
            } else {
                nr.getLabel().setTextColor(BALL_VIEW_TEXT_COLOR);
            }
            if (System.currentTimeMillis() - _lastUpdate > 3000L) {
                _paintAttachmentsOverlay = NbPreferences.forModule(EntityRealizerConstants.class).getBoolean("showAttachmentsOverlayIcons", true);
                _lastUpdate = System.currentTimeMillis();
            }
            if (_paintAttachmentsOverlay && ctx.getEntitySkeleton().hasAttachments()) {
                AffineTransform oldTransform = g2D.getTransform();
                g2D.translate(nr.getCenterX() - ballSize / 2.0, y);
                g2D.scale(0.75, 0.75);
                GraphicsUtils.drawPaperClip((Graphics2D)g2D, (double)0.0, (double)0.0);
                g2D.setTransform(oldTransform);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            g2D.setStroke(new BasicStroke());
            g2D.setColor(Color.blue);
            g2D.drawRect((int)ctx.getX(), (int)ctx.getY(), (int)ctx.getWidth(), (int)ctx.getHeight());
            LightweightEntityRealizer realizer = ctx.getRealizer();
            g2D.setColor(Color.red);
            g2D.drawRect((int)realizer.getX(), (int)realizer.getY(), (int)realizer.getWidth(), (int)realizer.getHeight());
        }
    }

    public void paintHotSpot(Graphics2D g2D, LightweightEntityRealizer realizer) throws Exception {
        this._hotSpotPainter.paintHotSpots((BA)realizer, g2D);
    }

    public void createLabels(LightweightEntityRealizer realizer) {
        MaltegoEntity entitySkeleton = realizer.getEntitySkeleton();
        if (entitySkeleton != null) {
            gB label = EntityLabels.createValueLabel((LightweightEntityRealizer)realizer);
            label.setModel((byte)4);
            EntityLabels.createPinLabel((LightweightEntityRealizer)realizer);
            EntityLabels.createNotesLabel((LightweightEntityRealizer)realizer);
            EntityLabels.createBookmarkLabel((LightweightEntityRealizer)realizer);
            label = EntityLabels.createNotesEditLabel((LightweightEntityRealizer)realizer);
            label.setModel((byte)0);
            label.setPosition((byte)105);
        } else if (realizer.isCollectionNode()) {
            gB label = EntityLabels.createCollectionNodeLabel((LightweightEntityRealizer)realizer);
            label.setModel((byte)4);
            EntityLabels.createPinLabel((LightweightEntityRealizer)realizer);
        }
    }

    public void update(LightweightEntityRealizer realizer, boolean isInitialUpdate) {
        CustomizableView view;
        if (isInitialUpdate && (view = CustomizableViewRegistry.getDefault().getView(realizer.getGraphEntity().getGraphID())) != null && view instanceof BallCustomizableView) {
            ((BallCustomizableView)view).update(realizer.getNode());
        }
        super.update(realizer, isInitialUpdate);
    }

    public void updateSize(LightweightEntityRealizer realizer) {
        this.updateSizeNode(realizer);
        this.updateSizeNotes(realizer);
        this.updateSizeBookmark(realizer);
        this.updateSizePin(realizer);
    }

    private void updateSizeNode(LightweightEntityRealizer realizer) {
        Y node = realizer.getNode();
        if (node != null) {
            double ballSize;
            double nodeWidth = ballSize = BallProperties.getBallSize(node);
            double nodeHeight = ballSize;
            if (realizer.getEntitySkeleton() != null || realizer.getEntitySkeleton() == null && realizer.isCollectionNode()) {
                gB label = realizer.getLabel();
                if (realizer.getEntitySkeleton() == null && realizer.isCollectionNode() && label instanceof CollectionNodeLabel) {
                    ((CollectionNodeLabel)label).setCollectionNodeLabelText((GraphPart)realizer.getGraphEntity());
                }
                String text = label.getText();
                int lines = 1;
                if (!StringUtilities.isNullOrEmpty((String)text)) {
                    lines = text.split("\n").length;
                }
                Font font = label.getFont().deriveFont((float)(ballSize / 4.5 / (double)lines));
                label.setFont(font);
                label.calculateSize();
                double labelWidth = label.getWidth();
                double labelHeight = label.getHeight();
                nodeWidth = Math.max(ballSize, labelWidth);
                nodeHeight = Math.max(ballSize, labelHeight);
                label.setFreeOffset((nodeWidth - labelWidth) / 2.0, (nodeHeight - labelHeight) / 2.0);
            }
            LOG.log(Level.FINE, "Ball {0} {1} Size={2},{3}", new Object[]{realizer.getGraphEntity(), realizer, nodeWidth, nodeHeight});
            realizer.setSizeForce(nodeWidth, nodeHeight);
        }
    }

    private void updateSizeNotes(LightweightEntityRealizer realizer) {
        if (realizer.labelCount() > 2) {
            Y node = realizer.getNode();
            double w = realizer.getWidth();
            gB notesLabel = realizer.getLabel(2);
            double notesX = w / 2.0 + BallProperties.getBallSize(node) / 2.0 - 12.0;
            double notesY = 1.0;
            notesLabel.setFreeOffset(notesX, notesY);
        }
    }

    private void updateSizeBookmark(LightweightEntityRealizer realizer) {
        if (realizer.labelCount() > 3) {
            Y node = realizer.getNode();
            double w = realizer.getWidth();
            gB bookmarkLabel = realizer.getLabel(3);
            double bookmarkX = w / 2.0 + BallProperties.getBallSize(node) / 2.0 - 17.0 - 12.0;
            double bookmarkY = 0.0;
            bookmarkLabel.setFreeOffset(bookmarkX, bookmarkY);
        }
    }

    private void updateSizePin(LightweightEntityRealizer realizer) {
        if (realizer.labelCount() > 1) {
            Y node = realizer.getNode();
            double w = realizer.getWidth();
            gB pinLabel = realizer.getLabel(1);
            double pinX = realizer.isCollectionNode() ? w - 16.0 - 0.0 : w / 2.0 + BallProperties.getBallSize(node) / 2.0;
            double pinY = 0.0;
            pinLabel.setFreeOffset(pinX, pinY);
        }
    }

    static {
        _lastUpdate = 0L;
    }
}

