/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.treelist.parts.entity;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.treelist.parts.PartNode;
import com.paterva.maltego.treelist.parts.PartsRowModel;
import com.paterva.maltego.treelist.parts.PartsTreelistModel;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.PresetsRelative;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class EntityRowModel
extends PartsRowModel<EntityID, MaltegoEntity> {
    private static final Logger LOG = Logger.getLogger(EntityRowModel.class.getName());
    public static final int COLUMN_SELECTED = 0;
    public static final int COLUMN_INSPECT = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_BOOKMARK = 3;
    public static final int COLUMN_PIN = 4;
    public static final int COLUMN_COLLECTED = 5;
    public static final int COLUMN_INCOMING = 6;
    public static final int COLUMN_OUTGOING = 7;
    public static final int COLUMN_TIME = 8;
    public static final int COLUMN_WEIGHT = 9;
    public static final int COLUMN_COUNT = 10;
    public static final String COLUMN_TIME_NAME = "Time";

    public EntityRowModel(PartsTreelistModel<EntityID, MaltegoEntity> partProvider, boolean small) {
        super(partProvider);
    }

    public int getColumnCount() {
        return 10;
    }

    public Object getValueFor(Object node, int column) {
        PartNode partNode = (PartNode)node;
        switch (column) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return partNode;
            }
            case 6: {
                return this.getIncoming(partNode);
            }
            case 7: {
                return this.getOutgoing(partNode);
            }
            case 8: {
                return this.getTime(partNode);
            }
            case 9: {
                return this.getWeight(partNode);
            }
        }
        LOG.log(Level.SEVERE, "Unknown column: {0}", column);
        return null;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return PartNode.class;
            }
            case 6: 
            case 7: {
                return Integer.class;
            }
            case 8: {
                return String.class;
            }
            case 9: {
                return Integer.class;
            }
        }
        LOG.log(Level.SEVERE, "Unknown column: {0}", column);
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Selected";
            }
            case 1: {
                return "Inspect";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Bookmark";
            }
            case 4: {
                return "Pinned";
            }
            case 5: {
                return "Collected";
            }
            case 6: {
                return "Incoming Links";
            }
            case 7: {
                return "Outgoing Links";
            }
            case 8: {
                return COLUMN_TIME_NAME;
            }
            case 9: {
                return "Weight";
            }
        }
        LOG.log(Level.SEVERE, "Unknown column: {0}", column);
        return null;
    }

    static String getTimeString(MaltegoEntity entity) {
        String timeString = null;
        DateTime time = EntityRowModel.getTime(entity);
        if (time != null) {
            timeString = time.toString();
        }
        return timeString;
    }

    static DateTime getTime(MaltegoEntity entity) {
        DateTime time = null;
        if (entity != null) {
            PropertyDescriptorCollection properties = entity.getProperties();
            ArrayList<DateTime> times = new ArrayList<DateTime>();
            for (PropertyDescriptor pd : properties) {
                Date[] dates;
                if (pd.isHidden()) continue;
                DateTime t = null;
                Class type = pd.getType();
                if (DateRange.class.equals((Object)type)) {
                    DateRange dateRange = (DateRange)entity.getValue(pd);
                    if (dateRange == null) {
                        dateRange = new DateRange(PresetsRelative.PRESETS_SINCE_UNIX_EPOCH_TIME);
                    }
                    t = dateRange.getFromDate();
                } else if (DateTime.class.equals((Object)type)) {
                    t = (DateTime)entity.getValue(pd);
                } else if (Date.class.equals((Object)type)) {
                    Date date = (Date)entity.getValue(pd);
                    if (date != null) {
                        times.add(new DateTime(date));
                    }
                } else if (Date[].class.equals((Object)type) && (dates = (Date[])entity.getValue(pd)) != null) {
                    for (Date date : dates) {
                        if (date == null) continue;
                        times.add(new DateTime(date));
                    }
                }
                if (t == null) continue;
                times.add(t);
            }
            if (!times.isEmpty()) {
                if (times.size() > 1) {
                    Collections.sort(times, (o1, o2) -> {
                        long t1 = o1.getTime();
                        long t2 = o2.getTime();
                        int result = t1 == 0L && t2 == 0L ? 0 : (t1 == 0L ? 1 : (t2 == 0L ? -1 : Long.compare(t1, t2)));
                        return result;
                    });
                }
                time = (DateTime)times.get(0);
            }
        }
        return time;
    }

    private int getIncoming(PartNode<EntityID, MaltegoEntity> partNode) {
        return this.getLinkCount(partNode, true);
    }

    private int getOutgoing(PartNode<EntityID, MaltegoEntity> partNode) {
        return this.getLinkCount(partNode, false);
    }

    private int getLinkCount(PartNode<EntityID, MaltegoEntity> partNode, boolean incoming) {
        int links = 0;
        try {
            GraphID graphID = this.getModel().getGraphID();
            EntityID entityID = partNode.getPartID();
            if (entityID != null) {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                links = incoming ? structureReader.getIncomingLinkCount(entityID) : structureReader.getOutgoingLinkCount(entityID);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return links;
    }

    private String getTime(PartNode<EntityID, MaltegoEntity> partNode) {
        String time = null;
        EntityID entityID = partNode.getPartID();
        if (entityID != null) {
            MaltegoEntity entity = this.getModel().getModelPart(entityID, null).orElse(null);
            time = EntityRowModel.getTimeString(entity);
        }
        return time;
    }

    private int getWeight(PartNode<EntityID, MaltegoEntity> partNode) {
        EntityID entityID = partNode.getPartID();
        if (entityID != null) {
            return this.getModel().getModelPart(entityID, null).map(MaltegoEntity::getWeight).orElse(0);
        }
        return 0;
    }
}

