/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.recovery.ui;

import com.google.gson.Gson;
import com.maltego.recovery.ui.BackupMetadata;
import com.paterva.maltego.graph.store.GraphStoreCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class RecoveryUtility {
    private static final Logger LOG = Logger.getLogger(RecoveryUtility.class.getName());
    private static final String METADATA_FILE = "backup.json";
    private static List<BackupMetadata> backupsCache;

    public static List<BackupMetadata> listBackups(boolean refreshCache) {
        if (refreshCache || backupsCache == null) {
            backupsCache = RecoveryUtility.fetchBackups();
        }
        return Collections.unmodifiableList(backupsCache);
    }

    private static List<BackupMetadata> fetchBackups() {
        String[] backupsList = GraphStoreCache.get().list();
        List<BackupMetadata> metadataList = Arrays.stream(backupsList).map(RecoveryUtility::getBackupFile).filter(metadataFile -> metadataFile.isFile()).map(metadataFile -> {
            try {
                return RecoveryUtility.readFromFile(metadataFile);
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, null, ex);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return metadataList;
    }

    private static BackupMetadata readFromFile(File file) throws IOException {
        byte[] allBytes = Files.readAllBytes(file.toPath());
        String json = new String(allBytes);
        return RecoveryUtility.fromJson(json);
    }

    private static BackupMetadata fromJson(String json) throws IOException {
        Gson gson = new Gson();
        return gson.fromJson(json, BackupMetadata.class);
    }

    static File getBackupFile(String graphIDString) {
        File graphBackupDir = new File(GraphStoreCache.get(), graphIDString);
        return new File(graphBackupDir, METADATA_FILE);
    }
}

