/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.nodes;

import com.paterva.maltego.transform.descriptor.Status;
import com.paterva.maltego.transform.descriptor.StatusItem;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformRepositoryRegistry;
import com.paterva.maltego.transform.descriptor.TransformSet;
import com.paterva.maltego.transform.manager.nodes.StatusItemNode;
import com.paterva.maltego.transform.manager.nodes.TransformProperties;
import com.paterva.maltego.transform.manager.sets.AddToSetAction;
import com.paterva.maltego.tx.inputs.global.registry.DefaultGlobalTransformInputsRepository;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInput;
import com.paterva.maltego.tx.inputs.global.registry.GlobalTransformInputsRepository;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.actions.DeleteAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.InstanceContent;

public class TransformNode
extends StatusItemNode
implements PropertyChangeListener {
    public TransformNode(TransformDefinition transform) {
        this(transform, false);
    }

    public TransformNode(TransformDefinition transform, boolean checkable) {
        this(transform, new InstanceContent(), checkable);
    }

    protected TransformNode(TransformDefinition transform, InstanceContent content, boolean checkable) {
        super(Children.LEAF, (StatusItem)transform, content, checkable);
        transform.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)transform));
        GlobalTransformInputsRepository repo = DefaultGlobalTransformInputsRepository.getDefault();
        for (DisplayDescriptor property : transform.getProperties()) {
            GlobalTransformInput input = repo.get(property.getName());
            if (input == null) continue;
            transform.setValue((PropertyDescriptor)property, input.getValue());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property;
        GlobalTransformInputsRepository repo = DefaultGlobalTransformInputsRepository.getDefault();
        GlobalTransformInput input = repo.get(property = evt.getPropertyName());
        if (input != null) {
            repo.getData().setValue((PropertyDescriptor)input.getDescriptor(), evt.getNewValue());
        }
        if ("disclaimerAccepted".equals(evt.getPropertyName()) || "enabled".equals(evt.getPropertyName())) {
            this.fireIconChange();
        }
    }

    public Image getIcon(int type) {
        Image main = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/Transform.png");
        Status status = this.getStatus();
        switch (status) {
            case Disabled: {
                Image disbaled = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/Disabled10.png");
                return ImageUtilities.mergeImages((Image)main, (Image)disbaled, (int)6, (int)6);
            }
            case RequiresDisclaimerAccept: {
                Image disclaim = ImageUtilities.loadImage((String)"com/paterva/maltego/transform/manager/resources/Popup10.png");
                return ImageUtilities.mergeImages((Image)main, (Image)disclaim, (int)6, (int)6);
            }
        }
        return main;
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        set.put((Node.Property)new TransformProperties.Location((Node)this));
        set.put((Node.Property)new TransformProperties.DefaultSets((Node)this));
        set.put((Node.Property)new TransformProperties.InputConstraint((Node)this));
        set.put((Node.Property)new TransformProperties.Output((Node)this));
        sheet.put(set);
        TransformProperties.addTransformInputs(sheet, this.getDefinition());
        TransformProperties.addHubSettings(sheet, this.getDefinition());
        return sheet;
    }

    private TransformDefinition getDefinition() {
        return (TransformDefinition)this.getLookup().lookup(TransformDefinition.class);
    }

    public void refreshProperties() {
        this.setSheet(this.createSheet());
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public void destroy() throws IOException {
        Runnable runnable = () -> {
            TransformRepositoryRegistry.getDefault().removeTransform(this.getDefinition().getName());
            this.fireNodeDestroyed();
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(DeleteAction.class), null, SystemAction.get(AddToSetAction.class)};
    }

    protected void createPasteTypes(Transferable t, List<PasteType> s) {
        Node[] n;
        super.createPasteTypes(t, s);
        final Node[] nodes = n = NodeTransfer.nodes((Transferable)t, (int)6);
        if (nodes != null) {
            s.add(new PasteType(){

                public Transferable paste() throws IOException {
                    TransformNode.this.pasteNode(nodes);
                    return null;
                }
            });
        }
    }

    private void pasteNode(Node[] nodes) {
        for (Node node : nodes) {
            TransformDefinition transform = (TransformDefinition)node.getLookup().lookup(TransformDefinition.class);
            TransformSet toSet = (TransformSet)this.getLookup().lookup(TransformSet.class);
            TransformSet fromSet = (TransformSet)node.getLookup().lookup(TransformSet.class);
            if (fromSet != null) {
                fromSet.removeTransform(transform.getName());
            }
            if (toSet == null) continue;
            toSet.addTransform(transform.getName());
        }
    }

    public static class ReadOnly
    extends TransformNode {
        public ReadOnly(TransformDefinition transform, InstanceContent content, boolean checkable) {
            super(transform, content, checkable);
        }

        public ReadOnly(TransformDefinition transform, boolean checkable) {
            super(transform, checkable);
        }

        public ReadOnly(TransformDefinition transform) {
            super(transform);
        }

        @Override
        public Action[] getActions(boolean popup) {
            return null;
        }

        @Override
        public boolean canDestroy() {
            return false;
        }
    }
}

