/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.manager.imex.seeds;

import com.paterva.maltego.archive.mtz.EntryFactory;
import com.paterva.maltego.archive.mtz.MaltegoArchiveReader;
import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.transform.descriptor.TransformSeed;
import com.paterva.maltego.transform.descriptor.TransformSeedRepository;
import com.paterva.maltego.transform.manager.imex.seeds.SeedConfig;
import com.paterva.maltego.transform.manager.imex.seeds.SeedExistInfo;
import com.paterva.maltego.transform.manager.imex.seeds.TransformSeedEntryFactory;
import com.paterva.maltego.transform.repository.FSTransformSeedRepository;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.openide.filesystems.FileObject;

public class SeedImporter
extends ConfigImporter {
    private final SeedExistInfo existInfo = new SeedExistInfo();

    public Config loadConfig(MaltegoArchiveReader reader) throws IOException {
        List seeds = reader.readAll((EntryFactory)new TransformSeedEntryFactory(), "Graph1");
        return this.createConfig(seeds, this.existInfo::exist);
    }

    public Config loadPreviousConfig(FileObject configRoot) throws IOException {
        FSTransformSeedRepository oldRepository = new FSTransformSeedRepository(configRoot);
        TransformSeed[] allSeeds = oldRepository.getAll();
        List<TransformSeed> seeds = Arrays.asList(allSeeds);
        return this.createConfig(seeds, seed -> !seed.isEnabled());
    }

    private Config createConfig(List<TransformSeed> seedsAll, Predicate<TransformSeed> exclude) {
        ArrayList<TransformSeed> seedsSelected = new ArrayList<TransformSeed>();
        for (TransformSeed seed : seedsAll) {
            if (exclude.test(seed)) continue;
            seedsSelected.add(seed);
        }
        if (seedsAll.size() > 0) {
            TransformSeed[] all = seedsAll.toArray(new TransformSeed[seedsAll.size()]);
            TransformSeed[] selected = seedsSelected.toArray(new TransformSeed[seedsSelected.size()]);
            return new SeedConfig(all, selected);
        }
        return null;
    }

    public int applyConfig(Config config) {
        SeedConfig seedConfig = (SeedConfig)config;
        for (TransformSeed seed : (TransformSeed[])seedConfig.getSelected()) {
            TransformSeedRepository.getDefault().add(seed);
        }
        return ((TransformSeed[])seedConfig.getSelected()).length;
    }
}

