/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.analytics.queue;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.maltego.analytics.queue.QueuedEvent;
import com.maltego.analytics.rest.AmplitudeRequestException;
import com.maltego.analytics.rest.AmplitudeRestClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class AnalyticsQueue {
    private static final Logger LOG = Logger.getLogger(AnalyticsQueue.class.getName());
    private final String name;
    private final int period;
    private final Queue<QueuedEvent> eventQueue;
    private final int sizeLimit = 921600;
    private final int countLimit = 1000;
    private ScheduledExecutorService scheduledExecutor;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private Listener listener = new Listener(){

        @Override
        public void onSent(List<QueuedEvent> events) {
        }

        @Override
        public void onError(List<QueuedEvent> events, AmplitudeRequestException ex) {
        }
    };

    public AnalyticsQueue(String name, int period) {
        this.name = name;
        this.period = period;
        this.eventQueue = new PriorityQueue<QueuedEvent>();
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public AnalyticsQueue(String name, int period, Listener listener) {
        this(name, period);
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listener = listener;
    }

    public void queue(QueuedEvent event) throws JsonProcessingException {
        this.queue(Collections.singletonList(event));
    }

    public void queue(List<QueuedEvent> events) throws JsonProcessingException {
        for (QueuedEvent e : events) {
            this.eventQueue.add(e);
            LOG.log(Level.INFO, "Event queued in {0} - id: {1}", new Object[]{this.name, e.getId().toString()});
        }
        if (!this.scheduled.get()) {
            this.scheduleTask();
        }
    }

    void scheduleTask() {
        if (this.eventQueue.isEmpty()) {
            LOG.log(Level.INFO, "No waiting event in {0} queue", this.name);
            this.scheduled.set(false);
        } else {
            LOG.log(Level.INFO, "Scheduling task for {0} queue", this.name);
            this.scheduledExecutor.schedule(this.createTask(), (long)this.period, TimeUnit.SECONDS);
            this.scheduled.set(true);
        }
    }

    Task createTask() {
        return new Task(this);
    }

    String getName() {
        return this.name;
    }

    Queue<QueuedEvent> getEventQueue() {
        return this.eventQueue;
    }

    int getSizeLimit() {
        return 921600;
    }

    int getCountLimit() {
        return 1000;
    }

    Listener getListener() {
        return this.listener;
    }

    static class Task
    implements Runnable {
        private static final Logger LOG = Logger.getLogger(Task.class.getName());
        private final AnalyticsQueue analyticsQueue;

        Task(AnalyticsQueue analyticsQueue) {
            this.analyticsQueue = analyticsQueue;
        }

        @Override
        public void run() {
            QueuedEvent peek;
            String queueName = this.analyticsQueue.getName();
            LOG.log(Level.INFO, "Running task for {0} queue", queueName);
            ArrayList<QueuedEvent> toSend = new ArrayList<QueuedEvent>();
            int payloadSize = 0;
            Queue<QueuedEvent> eventQueue = this.analyticsQueue.getEventQueue();
            while (!eventQueue.isEmpty() && toSend.size() < this.analyticsQueue.getCountLimit() && payloadSize + (peek = eventQueue.peek()).getEventJson().length() < this.analyticsQueue.getSizeLimit()) {
                QueuedEvent polled = eventQueue.poll();
                toSend.add(polled);
                payloadSize += polled.getEventJson().length();
            }
            List<String> collect = toSend.stream().map(qe -> qe.getEventJson()).collect(Collectors.toList());
            boolean sentSuccessfully = false;
            AmplitudeRequestException exception = null;
            try {
                AmplitudeRestClient.sendEvent(collect);
                sentSuccessfully = true;
            }
            catch (AmplitudeRequestException ex) {
                exception = ex;
            }
            this.analyticsQueue.scheduleTask();
            if (sentSuccessfully) {
                LOG.log(Level.INFO, "{0} events sent successfully, removing from queue {1}", new Object[]{toSend.size(), queueName});
                this.analyticsQueue.getListener().onSent(toSend);
            } else {
                LOG.log(Level.WARNING, "Error on sending {0} events, removing from queue {1}", new Object[]{toSend.size(), queueName});
                this.analyticsQueue.getListener().onError(toSend, exception);
            }
        }
    }

    public static interface Listener {
        public void onSent(List<QueuedEvent> var1);

        public void onError(List<QueuedEvent> var1, AmplitudeRequestException var2);
    }
}

