/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.descriptor;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.descriptor.TransformServerInfo;
import com.paterva.maltego.typing.DataSource;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public abstract class TransformSettingsLogger {
    private static final Logger LOG = Logger.getLogger(TransformSettingsLogger.class.getName());
    private static TransformSettingsLogger _default;

    public static synchronized TransformSettingsLogger getDefault() {
        if (_default == null) {
            Collection loggers = Lookup.getDefault().lookupAll(TransformSettingsLogger.class);
            _default = loggers.isEmpty() ? new DefaultTransformSettingsLogger() : (loggers.size() == 1 ? (TransformSettingsLogger)loggers.iterator().next() : new CompositeTransformSettingsLogger(loggers));
        }
        return _default;
    }

    public void logTransformSettings(DataSource transformInputs, TransformDefinition transform, TransformServerInfo server) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        String transformName = transform.getDisplayName();
        LOG.log(Level.FINE, "=== Transform Settings for: {0} ===", transformName);
        LOG.log(Level.FINE, "--- Transform Input Settings ---");
        DisplayDescriptorCollection transformProperties = transform.getProperties();
        this.logDataSourceSettings(transformInputs, transformProperties);
        LOG.log(Level.FINE, "--- Transform Settings ---");
        this.logDataSourceSettings(transform, transformProperties);
        LOG.log(Level.FINE, "--- Hub Item Settings ---");
        this.logHubItemSettings(transform, server);
        LOG.log(Level.FINE, "--- Global Transform Settings ---");
        this.logGlobalTransformSettings(transform, transformProperties);
        LOG.log(Level.FINE, "=== End Transform Settings for: {0} ===", transformName);
    }

    protected void logHubItemSettings(TransformDefinition transform, TransformServerInfo server) {
    }

    protected void logGlobalTransformSettings(TransformDefinition transform, DisplayDescriptorCollection transformProperties) {
    }

    protected void logDataSourceSettings(DataSource dataSource, DisplayDescriptorCollection properties) {
        if (dataSource == null || properties == null) {
            return;
        }
        for (DisplayDescriptor property : properties) {
            try {
                Object value = dataSource.getValue((PropertyDescriptor)property);
                if (value == null) continue;
                LOG.log(Level.FINE, "  {0} ({1}, Optional={2}, Popup={3}, DefaultValue=\"{4}\") = \"{5}\"", new Object[]{property.getName(), property.getDisplayName(), property.isNullable(), property.isPopup(), property.getDefaultValue(), value});
            }
            catch (Exception ex) {
                LOG.log(Level.FINER, "Error getting value for property {0}: {1}", new Object[]{property.getName(), ex.getMessage()});
            }
        }
    }

    private static class CompositeTransformSettingsLogger
    extends TransformSettingsLogger {
        private final Collection<? extends TransformSettingsLogger> _loggers;

        CompositeTransformSettingsLogger(Collection<? extends TransformSettingsLogger> loggers) {
            this._loggers = loggers;
        }

        @Override
        protected void logHubItemSettings(TransformDefinition transform, TransformServerInfo server) {
            for (TransformSettingsLogger transformSettingsLogger : this._loggers) {
                transformSettingsLogger.logHubItemSettings(transform, server);
            }
        }

        @Override
        protected void logGlobalTransformSettings(TransformDefinition transform, DisplayDescriptorCollection transformProperties) {
            for (TransformSettingsLogger transformSettingsLogger : this._loggers) {
                transformSettingsLogger.logGlobalTransformSettings(transform, transformProperties);
            }
        }
    }

    private static class DefaultTransformSettingsLogger
    extends TransformSettingsLogger {
        private DefaultTransformSettingsLogger() {
        }
    }
}

