/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.inputform;

import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.typing.editing.inputform.InputForm;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InputFormPanel
extends JPanel {
    private InputForm _form;
    private Component _formComponent;

    public InputFormPanel() {
        this.setLayout(new CardLayout());
        this.add((Component)this.getWaitControl(), "wait");
        this.add(this.getFormControl(), "form");
        this.showWait();
    }

    private void showWait() {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, "wait");
    }

    private void showForm() {
        CardLayout layout = (CardLayout)this.getLayout();
        layout.show(this, "form");
    }

    private Component getFormControl() {
        if (this._formComponent == null) {
            this._formComponent = this.createFormControl();
        }
        return this._formComponent;
    }

    private Component createFormControl() {
        if (this._form == null) {
            return new JPanel();
        }
        TreeMap<String, Object> settings = new TreeMap<String, Object>();
        settings.put("useRequiredFieldColor", Boolean.FALSE);
        settings.put("useErrorColor", Boolean.FALSE);
        settings.put("showDescriptions", Boolean.TRUE);
        Component component = ComponentFactories.form(settings).createEditingComponent(this._form, this._form.getPropertyConfiguration().getProperties(), this._form.getPropertyConfiguration().getGroups());
        return component;
    }

    private JComponent getWaitControl() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(new JLabel("Please wait..."));
        return panel;
    }

    public void setForm(InputForm form) {
        this.showWait();
        Component old = this.getFormControl();
        this._form = form;
        this._formComponent = this.createFormControl();
        this.remove(old);
        this.add(this._formComponent, "form");
        this.showForm();
    }

    public InputForm getForm() {
        return this._form;
    }
}

