/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form.adapters;

import com.paterva.maltego.typing.editing.form.adapters.AbstractControlAdapter;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;

class DatePickerAdapter
extends AbstractControlAdapter<JXDatePicker, Date> {
    private DateFormat _format;

    public DatePickerAdapter(DateFormat format) {
        this._format = format;
    }

    @Override
    public JXDatePicker create() {
        JXDatePicker control = new JXDatePicker();
        control.setFormats(new DateFormat[]{this._format});
        control.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("datePickerCommit".equals(e.getActionCommand())) {
                    DatePickerAdapter.this.fireActionPerformed(e);
                }
            }
        });
        control.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    DatePickerAdapter.this.fireChange();
                }
            }
        });
        Color weekendColor = UIManager.getLookAndFeelDefaults().getColor("JXMonthViewMod.weekendForeground");
        JXMonthView mv = control.getMonthView();
        mv.setFirstDayOfWeek(2);
        mv.setDayForeground(7, weekendColor);
        mv.setDayForeground(1, weekendColor);
        return control;
    }

    @Override
    protected void set(JXDatePicker component, Date value) {
        component.setDate(value);
    }

    @Override
    protected Date get(JXDatePicker component) {
        return component.getDate();
    }

    @Override
    protected boolean empty(JXDatePicker component) {
        return component.getDate() == null;
    }

    @Override
    protected void setBackground(JXDatePicker component, Color color) {
        component.getEditor().setBackground(color);
    }

    @Override
    protected Color getBackground(JXDatePicker component) {
        return component.getEditor().getBackground();
    }
}

