/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileBrowserPanel
extends JPanel {
    private JTextField _textField = new JTextField();
    private JLabel _icon = new JLabel();
    private JButton _button = new JButton("...");
    private String _defaultBrowseDir;
    private File _file;
    private EventListenerList _listeners;
    private boolean _textChanged = false;
    private String _approveButtonText = "Ok";
    private String _approveButtonToolTipText = "";
    private String _dialogTitle = "Select File";
    private FileFilter _fileFilter = null;
    private boolean _selectFiles = true;
    private boolean _selectDirectories = true;

    public FileBrowserPanel() {
        super(new BorderLayout());
        this._button.setMargin(new Insets(0, 0, 0, 0));
        this._button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = FileBrowserPanel.this.browse(FileBrowserPanel.this._button);
                if (file != null) {
                    FileBrowserPanel.this.setFile(file);
                    FileBrowserPanel.this.fireActionPerformed();
                }
            }
        });
        this.add((Component)this._icon, "West");
        this.add((Component)this._textField, "Center");
        this.add((Component)this._button, "East");
        this._textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileBrowserPanel.this.setFile(new File(FileBrowserPanel.this._textField.getText()));
                FileBrowserPanel.this.fireActionPerformed();
            }
        });
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FileBrowserPanel.this._textChanged = true;
                FileBrowserPanel.this.fireChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FileBrowserPanel.this._textChanged = true;
                FileBrowserPanel.this.fireChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FileBrowserPanel.this._textChanged = true;
                FileBrowserPanel.this.fireChange();
            }
        });
    }

    protected JTextField getTextField() {
        return this._textField;
    }

    public void setFile(File file) {
        this._file = file;
        this.update();
    }

    public File getFile() {
        if (this._textChanged) {
            this.setFile(new File(this._textField.getText()));
            this._textChanged = false;
        }
        return this._file;
    }

    private void update() {
        if (this._file == null) {
            this._textField.setText("");
            this._icon.setIcon(null);
        } else {
            this._textField.setText(this._file.getAbsolutePath());
            if (this.getIconVisible()) {
                this._icon.setIcon(FileBrowserPanel.getIcon(this._file));
            }
        }
    }

    private File browse(Component parent) {
        JFileChooser chooser = new JFileChooser();
        if (!StringUtilities.isNullOrEmpty((String)this._textField.getText())) {
            chooser.setSelectedFile(new File(this._textField.getText()));
        } else if (!StringUtilities.isNullOrEmpty((String)this._defaultBrowseDir)) {
            chooser.setCurrentDirectory(new File(this._defaultBrowseDir));
        }
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(this.getFileSelectionMode());
        chooser.setApproveButtonText(this.getApproveButtonText());
        chooser.setApproveButtonToolTipText(this.getApproveButtonToolTipText());
        chooser.setDialogTitle(this.getDialogTitle());
        chooser.setFileFilter(this.getFileFilter());
        if (chooser.showDialog(parent, this.getDialogTitle()) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    protected static Icon getIcon(File file) {
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            return FileSystemView.getFileSystemView().getSystemIcon(file);
        }
        return null;
    }

    private EventListenerList listeners() {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        return this._listeners;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners().add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners().remove(ActionListener.class, listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners().add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners().remove(ChangeListener.class, listener);
    }

    protected void fireActionPerformed() {
        ActionEvent e = new ActionEvent(this, 0, "valueSelected");
        if (this._listeners != null) {
            for (ActionListener l : (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                l.actionPerformed(e);
            }
        }
    }

    protected void fireChange() {
        if (this._listeners != null) {
            for (ChangeListener l : (ChangeListener[])this._listeners.getListeners(ChangeListener.class)) {
                l.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public boolean getIconVisible() {
        return this._icon.isVisible();
    }

    public void setIconVisible(boolean showIcon) {
        this._icon.setVisible(showIcon);
    }

    public Icon getIcon() {
        return this._icon.getIcon();
    }

    public void setIcon(Icon icon) {
        this._icon.setIcon(icon);
    }

    public String getApproveButtonText() {
        return this._approveButtonText;
    }

    public void setApproveButtonText(String approveButtonText) {
        this._approveButtonText = approveButtonText;
    }

    public String getApproveButtonToolTipText() {
        return this._approveButtonToolTipText;
    }

    public void setApproveButtonToolTipText(String approveButtonToolTipText) {
        this._approveButtonToolTipText = approveButtonToolTipText;
    }

    public String getDialogTitle() {
        return this._dialogTitle;
    }

    public void setDialogTitle(String dialogTitle) {
        this._dialogTitle = dialogTitle;
    }

    public FileFilter getFileFilter() {
        return this._fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this._fileFilter = fileFilter;
    }

    public boolean isSelectFiles() {
        return this._selectFiles;
    }

    public void setSelectFiles(boolean selectFiles) {
        this._selectFiles = selectFiles;
    }

    public boolean isSelectDirectories() {
        return this._selectDirectories;
    }

    public void setSelectDirectories(boolean selectDirectories) {
        this._selectDirectories = selectDirectories;
    }

    private int getFileSelectionMode() {
        if (this.isSelectFiles() && this.isSelectDirectories()) {
            return 2;
        }
        if (this.isSelectFiles() && !this.isSelectDirectories()) {
            return 0;
        }
        return 1;
    }
}

