/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class NormalException
extends Exception {
    private static final Logger LOGGER = Logger.getLogger(NormalException.class.getName());
    private boolean _showStackTrace = false;

    public static boolean isShowStackTrace(Throwable t) {
        if (t instanceof NormalException) {
            return ((NormalException)t).isShowStackTrace();
        }
        return true;
    }

    public static void showStackTrace(Throwable t) {
        if (NormalException.isShowStackTrace(t)) {
            Exceptions.printStackTrace((Throwable)t);
        } else {
            NormalException.logStackTrace(t);
        }
    }

    public static void logStackTrace(Throwable t) {
        LOGGER.log(Level.INFO, t.getMessage(), t);
    }

    public NormalException(boolean showStackTrace) {
        this._showStackTrace = showStackTrace;
    }

    public NormalException(NormalException ex) {
        this(ex, ex.isShowStackTrace());
    }

    public NormalException(String message, boolean showStackTrace) {
        super(message);
        this._showStackTrace = showStackTrace;
    }

    public NormalException(String message, Throwable cause, boolean showStackTrace) {
        super(message, cause);
        this._showStackTrace = showStackTrace;
    }

    public NormalException(Throwable cause, boolean showStackTrace) {
        super(cause);
        this._showStackTrace = showStackTrace;
    }

    public boolean isShowStackTrace() {
        return this._showStackTrace;
    }
}

