/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.archive.mtz;

import com.paterva.maltego.archive.mtz.Entry;
import com.paterva.maltego.archive.mtz.MaltegoArchiveOutputStream;
import com.paterva.maltego.archive.mtz.MaltegoWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class MaltegoRecoveryWriter
implements MaltegoWriter {
    private final MaltegoArchiveOutputStream stream;

    private MaltegoRecoveryWriter(MaltegoArchiveOutputStream stream) {
        this.stream = stream;
    }

    @Override
    public <T> void write(Entry<T> entry) throws IOException {
        try {
            this.stream.addEntry(entry);
            entry.write(entry.getData(), this.stream);
        }
        finally {
            this.stream.closeEntry();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public static MaltegoRecoveryWriter createRecoveryWriter(File recoveredFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(recoveredFile);
        MaltegoArchiveOutputStream maos = new MaltegoArchiveOutputStream(fos);
        return new MaltegoRecoveryWriter(maos);
    }
}

