/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.java.source.parsing.CachingArchive;

public class CTSymArchive
extends CachingArchive {
    private static final Logger LOG = Logger.getLogger(CTSymArchive.class.getName());
    private final File ctSym;
    private final String pathToRootInCtSym;
    private ZipFile zipFile;
    private Map<String, Set<String>> pkgs;

    CTSymArchive(@NonNull File archive, @NullAllowed String pathToRootInArchive, @NonNull File ctSym, @NullAllowed String pathToRootInCtSym) {
        super(archive, pathToRootInArchive, true);
        this.ctSym = ctSym;
        this.pathToRootInCtSym = pathToRootInCtSym;
    }

    @Override
    protected void beforeInit() throws IOException {
        this.zipFile = new ZipFile(this.ctSym);
        this.pkgs = new HashMap<String, Set<String>>();
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            String basename;
            String dirname;
            int i;
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (this.pathToRootInCtSym != null) {
                if (!name.startsWith(this.pathToRootInCtSym)) continue;
                i = name.lastIndexOf(47);
                dirname = i < this.pathToRootInCtSym.length() ? "" : name.substring(this.pathToRootInCtSym.length(), i);
                basename = name.substring(i + 1);
            } else {
                i = name.lastIndexOf(47);
                dirname = i == -1 ? "" : name.substring(0, i);
                basename = name.substring(i + 1);
            }
            Set<String> content = this.pkgs.get(dirname);
            if (content == null) {
                content = new HashSet<String>();
                this.pkgs.put(dirname, content);
            }
            content.add(basename);
        }
    }

    @Override
    protected short getFlags(@NonNull String dirname) throws IOException {
        boolean isPublic = this.pkgs.containsKey(dirname);
        LOG.log(Level.FINE, "Package: {0} is public: {1}", new Object[]{dirname, isPublic});
        return (short)(!isPublic ? 1 : 0);
    }

    @Override
    protected boolean includes(int flags, String folder, String name) {
        if (flags == 0) {
            Set<String> content = this.pkgs.get(folder);
            return content == null ? false : content.contains(name);
        }
        return super.includes(flags, folder, name);
    }

    @Override
    protected void afterInit(boolean success) throws IOException {
        this.pkgs = null;
    }

    @Override
    protected ZipFile getArchive(short flags) {
        return flags == 0 ? this.zipFile : super.getArchive(flags);
    }

    @Override
    protected String getPathToRoot(short flags) {
        return flags == 0 ? this.pathToRootInCtSym : super.getPathToRoot(flags);
    }
}

