/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ScriptOrModule {
    protected final JSContext context;
    protected final Source source;
    private volatile Map<String, Source> importSourceCache;
    private static final AtomicReferenceFieldUpdater<ScriptOrModule, Map> IMPORT_SOURCE_CACHE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ScriptOrModule.class, Map.class, "importSourceCache");

    public ScriptOrModule(JSContext context, Source source) {
        this.context = context;
        this.source = source;
    }

    public final JSContext getContext() {
        return this.context;
    }

    public final Source getSource() {
        return this.source;
    }

    public void rememberImportedModuleSource(String moduleSpecifier, Source moduleSource) {
        this.getImportSourceCache().put(moduleSpecifier, moduleSource);
    }

    private Map<String, Source> getImportSourceCache() {
        Map<String, Source> cache = this.importSourceCache;
        if (cache == null && !IMPORT_SOURCE_CACHE_UPDATER.compareAndSet(this, null, cache = new ConcurrentHashMap<String, Source>())) {
            cache = this.importSourceCache;
        }
        return cache;
    }
}

