/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToBigInt64Node;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyValueTypes;

public abstract class ToWebAssemblyValueNode
extends JavaScriptBaseNode {
    @Node.Child
    JSToInt32Node toInt32Node;
    @Node.Child
    JSToNumberNode toNumberNode = JSToNumberNode.create();
    @Node.Child
    JSToBigInt64Node toBigInt64Node;

    protected ToWebAssemblyValueNode() {
        this.toInt32Node = JSToInt32Node.create();
        this.toBigInt64Node = JSToBigInt64Node.create();
    }

    public static ToWebAssemblyValueNode create() {
        return ToWebAssemblyValueNodeGen.create();
    }

    public static ToWebAssemblyValueNode getUncached() {
        return Uncached.INSTANCE;
    }

    public abstract Object execute(Object var1, String var2);

    @Specialization
    protected Object convert(Object value, String type) {
        assert (this.getLanguage().getJSContext().getContextOptions().isWasmBigInt() || !JSWebAssemblyValueTypes.isI64(type));
        if (JSWebAssemblyValueTypes.isI64(type)) {
            return this.toBigInt64Node.execute(value);
        }
        if (JSWebAssemblyValueTypes.isI32(type)) {
            return this.toInt32Node.executeInt(value);
        }
        Number numberValue = this.toNumberNode.executeNumber(value);
        double doubleValue = JSRuntime.toDouble(numberValue);
        if (JSWebAssemblyValueTypes.isF32(type)) {
            return Float.valueOf((float)doubleValue);
        }
        assert (JSWebAssemblyValueTypes.isF64(type));
        return doubleValue;
    }

    static class Uncached
    extends ToWebAssemblyValueNode {
        static final Uncached INSTANCE = new Uncached();

        Uncached() {
        }

        @Override
        public Object execute(Object value, String type) {
            assert (this.getLanguage().getJSContext().getContextOptions().isWasmBigInt() || !JSWebAssemblyValueTypes.isI64(type));
            if (JSWebAssemblyValueTypes.isI64(type)) {
                return JSRuntime.toBigInt(value).longValue();
            }
            if (JSWebAssemblyValueTypes.isI32(type)) {
                return JSRuntime.toInt32(value);
            }
            double doubleValue = JSRuntime.toDouble(value);
            if (JSWebAssemblyValueTypes.isF32(type)) {
                return Float.valueOf((float)doubleValue);
            }
            assert (JSWebAssemblyValueTypes.isF64(type));
            return doubleValue;
        }
    }
}

