/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNodeGen;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRealm;

@ImportStatic(value={JSConfig.class})
public abstract class ForeignObjectPrototypeNode
extends JavaScriptBaseNode {
    public abstract DynamicObject executeDynamicObject(Object var1);

    @Specialization(limit="InteropLibraryLimit")
    public DynamicObject doTruffleObject(Object truffleObject, @CachedLibrary(value="truffleObject") InteropLibrary interop) {
        JSRealm realm = this.getRealm();
        if (interop.hasArrayElements(truffleObject)) {
            return realm.getArrayPrototype();
        }
        if (interop.isExecutable(truffleObject) || interop.isInstantiable(truffleObject)) {
            return realm.getFunctionPrototype();
        }
        if (interop.isInstant(truffleObject)) {
            return realm.getDatePrototype();
        }
        if (interop.hasHashEntries(truffleObject)) {
            return realm.getMapPrototype();
        }
        if (interop.hasIterator(truffleObject)) {
            return realm.getForeignIterablePrototype();
        }
        if (interop.isString(truffleObject)) {
            return realm.getStringPrototype();
        }
        if (interop.isNumber(truffleObject)) {
            return realm.getNumberPrototype();
        }
        if (interop.isBoolean(truffleObject)) {
            return realm.getBooleanPrototype();
        }
        return realm.getObjectPrototype();
    }

    public static ForeignObjectPrototypeNode create() {
        return ForeignObjectPrototypeNodeGen.create();
    }
}

