/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;

@GenerateUncached
@ImportStatic(value={JSConfig.class})
public abstract class JSToBooleanNode
extends JavaScriptBaseNode {
    protected JSToBooleanNode() {
    }

    public abstract boolean executeBoolean(Object var1);

    public static JSToBooleanNode create() {
        return JSToBooleanNodeGen.create();
    }

    @Specialization
    protected static boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static boolean doNull(Object value) {
        return false;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static boolean doUndefined(Object value) {
        return false;
    }

    @Specialization
    protected static boolean doInt(int value) {
        return value != 0;
    }

    @Specialization
    protected static boolean doLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected static boolean doDouble(double value) {
        return value != 0.0 && !Double.isNaN(value);
    }

    @Specialization
    protected static boolean doBigInt(BigInt value) {
        return value.compareTo(BigInt.ZERO) != 0;
    }

    @Specialization
    protected static boolean doLazyString(JSLazyString value) {
        return !value.isEmpty();
    }

    @Specialization
    protected static boolean doString(String value) {
        return value.length() > 0;
    }

    @Specialization(guards={"isJSObject(value)"})
    protected static boolean doObject(Object value) {
        return true;
    }

    @Specialization
    protected static boolean doSymbol(Symbol value) {
        return true;
    }

    @Specialization(guards={"isForeignObject(value)"}, limit="InteropLibraryLimit")
    protected final boolean doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            return false;
        }
        try {
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isString(value)) {
                return !interop.asString(value).isEmpty();
            }
            if (interop.isNumber(value)) {
                if (interop.fitsInInt(value)) {
                    return JSToBooleanNode.doInt(interop.asInt(value));
                }
                if (interop.fitsInLong(value)) {
                    return JSToBooleanNode.doLong(interop.asLong(value));
                }
                if (interop.fitsInDouble(value)) {
                    return JSToBooleanNode.doDouble(interop.asDouble(value));
                }
                return true;
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(value, (InteropException)((Object)e), this);
        }
        return true;
    }
}

