/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.MemoryFence;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSIdenticalNode.class)
public final class JSIdenticalNodeGen
extends JSIdenticalNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int state_1_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile flattenA;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile flattenB;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile sameLen;
    @Node.Child
    private NullA0Data nullA0_cache;
    @Node.Child
    private NullB0Data nullB0_cache;
    @CompilerDirectives.CompilationFinal
    private DifferentTypesCachedData differentTypesCached_cache;
    @CompilerDirectives.CompilationFinal
    private NumberCachedData numberCached_cache;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;

    private JSIdenticalNodeGen(JavaScriptNode left, JavaScriptNode right, int type) {
        super(left, right, type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        Object rightNodeValue_;
        CharSequence leftNodeValue_;
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        if ((state_0 & 1) != 0 && leftNodeValue instanceof Integer) {
            int n = (Integer)leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_2 = (Integer)rightNodeValue;
                return JSIdenticalNode.doInt(n, rightNodeValue_2);
            }
        }
        if ((state_0 & 2) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue);
            if (JSTypesGen.isImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue)) {
                double rightNodeValue_3 = JSTypesGen.asImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue);
                return this.doDouble(d, rightNodeValue_3);
            }
        }
        if ((state_0 & 4) != 0 && leftNodeValue instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_4 = (Boolean)rightNodeValue;
                return JSIdenticalNode.doBoolean(bl, rightNodeValue_4);
            }
        }
        if ((state_0 & 0x18) != 0 && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if ((state_0 & 8) != 0 && rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_5 = (BigInt)rightNodeValue;
                return JSIdenticalNode.doBigInt(bigInt, rightNodeValue_5);
            }
            if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue)) {
                double rightNodeValue_6 = JSTypesGen.asImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue);
                return JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue_6);
            }
        }
        if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue);
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_7 = (BigInt)rightNodeValue;
                return JSIdenticalNode.doDoubleBigInt(d, rightNodeValue_7);
            }
        }
        if ((state_0 & 0x1C0) != 0) {
            DynamicObject dynamicObject;
            if ((state_0 & 0xC0) != 0) {
                if ((state_0 & 0x40) != 0 && JSGuards.isUndefined(leftNodeValue)) {
                    return JSIdenticalNode.doUndefinedA(leftNodeValue, rightNodeValue);
                }
                if ((state_0 & 0x80) != 0 && JSGuards.isUndefined(rightNodeValue)) {
                    return JSIdenticalNode.doUndefinedB(leftNodeValue, rightNodeValue);
                }
            }
            if ((state_0 & 0x100) != 0 && JSTypes.isDynamicObject(leftNodeValue) && JSGuards.isJSObject(dynamicObject = (DynamicObject)leftNodeValue)) {
                return JSIdenticalNode.doJSObjectA(dynamicObject, rightNodeValue);
            }
        }
        if ((state_0 & 0x1FE00) != 0) {
            DynamicObject dynamicObject;
            if ((state_0 & 0x200) != 0 && JSTypes.isDynamicObject(rightNodeValue) && JSGuards.isJSObject(dynamicObject = (DynamicObject)rightNodeValue)) {
                return JSIdenticalNode.doJSObjectB(leftNodeValue, dynamicObject);
            }
            if ((state_0 & 0x1FC00) != 0) {
                if ((state_0 & 0x400) != 0 && JSGuards.isJSNull(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    return JSIdenticalNode.doNullNull(leftNodeValue, rightNodeValue);
                }
                if ((state_0 & 0x800) != 0 && JSGuards.isJSNull(leftNodeValue) && JSGuards.isUndefined(rightNodeValue)) {
                    return JSIdenticalNode.doNullUndefined(leftNodeValue, rightNodeValue);
                }
                if ((state_0 & 0x1000) != 0 && JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    return JSIdenticalNode.doUndefinedNull(leftNodeValue, rightNodeValue);
                }
                if ((state_0 & 0x2000) != 0) {
                    void var5_13;
                    NullA0Data nullA0Data = this.nullA0_cache;
                    while (var5_13 != null) {
                        if (var5_13.bInterop_.accepts(rightNodeValue) && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
                            return JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, var5_13.bInterop_);
                        }
                        NullA0Data nullA0Data2 = var5_13.next_;
                    }
                }
                if ((state_0 & 0x4000) != 0 && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
                    return this.nullA1Boundary(state_0, state_1, leftNodeValue, rightNodeValue);
                }
                if ((state_0 & 0x8000) != 0) {
                    void var5_16;
                    NullB0Data nullB0Data = this.nullB0_cache;
                    while (var5_16 != null) {
                        if (var5_16.aInterop_.accepts(leftNodeValue) && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                            return JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, var5_16.aInterop_);
                        }
                        NullB0Data nullB0Data2 = var5_16.next_;
                    }
                }
                if ((state_0 & 0x10000) != 0 && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    return this.nullB1Boundary(state_0, state_1, leftNodeValue, rightNodeValue);
                }
            }
        }
        if ((state_0 & 0xE0000) != 0 && rightNodeValue instanceof JSLazyString) {
            JSLazyString jSLazyString = (JSLazyString)rightNodeValue;
            if ((state_0 & 0x60000) != 0 && leftNodeValue instanceof JSLazyString) {
                leftNodeValue_ = (JSLazyString)leftNodeValue;
                if ((state_0 & 0x20000) != 0 && JSGuards.isReferenceEquals(leftNodeValue_, jSLazyString)) {
                    return JSIdenticalNode.doLazyStringReference(leftNodeValue_, jSLazyString);
                }
                if ((state_0 & 0x40000) != 0) {
                    return JSIdenticalNode.doLazyString(leftNodeValue_, jSLazyString, this.flattenA, this.flattenB, this.sameLen);
                }
            }
            if ((state_0 & 0x80000) != 0 && JSTypesGen.isImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue)) {
                leftNodeValue_ = JSTypesGen.asImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue);
                return JSIdenticalNode.doStringLazyString((String)leftNodeValue_, jSLazyString, this.flattenB, this.sameLen);
            }
        }
        if ((state_0 & 0x700000) != 0 && JSTypesGen.isImplicitString((state_1 & 0xE000) >>> 13, rightNodeValue)) {
            String string = JSTypesGen.asImplicitString((state_1 & 0xE000) >>> 13, rightNodeValue);
            if ((state_0 & 0x100000) != 0 && leftNodeValue instanceof JSLazyString) {
                leftNodeValue_ = (JSLazyString)leftNodeValue;
                return JSIdenticalNode.doLazyStringString(leftNodeValue_, string, this.flattenA, this.sameLen);
            }
            if ((state_0 & 0x600000) != 0 && JSTypesGen.isImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue)) {
                leftNodeValue_ = JSTypesGen.asImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue);
                if ((state_0 & 0x200000) != 0 && JSGuards.isReferenceEquals(leftNodeValue_, string)) {
                    return JSIdenticalNode.doStringIdentity((String)leftNodeValue_, string);
                }
                if ((state_0 & 0x400000) != 0) {
                    return JSIdenticalNode.doString((String)leftNodeValue_, string);
                }
            }
        }
        if ((state_0 & 0x800000) != 0 && leftNodeValue instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue;
            if (rightNodeValue instanceof Symbol) {
                rightNodeValue_ = (Symbol)rightNodeValue;
                return JSIdenticalNode.doSymbol(symbol, (Symbol)rightNodeValue_);
            }
        }
        if ((state_0 & 0x3F000000) != 0) {
            if ((state_0 & 0x1000000) != 0 && JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0x2000000) != 0 && JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0x4000000) != 0) {
                void var5_22;
                DifferentTypesCachedData differentTypesCachedData = this.differentTypesCached_cache;
                while (var5_22 != null) {
                    if (leftNodeValue.getClass() == var5_22.cachedClassA_ && rightNodeValue.getClass() == var5_22.cachedClassB_) {
                        assert (JSIdenticalNode.isNonObjectType(var5_22.cachedClassA_) || JSIdenticalNode.isNonObjectType(var5_22.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(var5_22.cachedClassA_, var5_22.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, var5_22.cachedClassA_, var5_22.cachedClassB_);
                    }
                    DifferentTypesCachedData differentTypesCachedData2 = var5_22.next_;
                }
            }
            if ((state_0 & 0x8000000) != 0 && JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0x10000000) != 0 && JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
                return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
            }
            if ((state_0 & 0x20000000) != 0) {
                void var5_25;
                NumberCachedData numberCachedData = this.numberCached_cache;
                while (var5_25 != null) {
                    assert (var5_25.cachedClassA_ != null);
                    assert (var5_25.cachedClassB_ != null);
                    if (leftNodeValue.getClass() == var5_25.cachedClassA_ && rightNodeValue.getClass() == var5_25.cachedClassB_) {
                        return this.doNumberCached(leftNodeValue, rightNodeValue, var5_25.cachedClassA_, var5_25.cachedClassB_);
                    }
                    NumberCachedData numberCachedData2 = var5_25.next_;
                }
            }
        }
        if ((state_0 & 0x40000000) != 0 && leftNodeValue instanceof Number) {
            Number number = (Number)leftNodeValue;
            if (rightNodeValue instanceof Number) {
                rightNodeValue_ = (Number)rightNodeValue;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_)) {
                    return this.doNumber(number, (Number)rightNodeValue_);
                }
            }
        }
        if ((state_0 & Integer.MIN_VALUE) != 0 || (state_1 & 3) != 0) {
            if ((state_0 & Integer.MIN_VALUE) != 0) {
                void var5_29;
                ForeignObject0Data foreignObject0Data = this.foreignObject0_cache;
                while (var5_29 != null) {
                    if (var5_29.aInterop_.accepts(leftNodeValue) && var5_29.bInterop_.accepts(rightNodeValue) && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue)) {
                        return JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, var5_29.aInterop_, var5_29.bInterop_);
                    }
                    ForeignObject0Data foreignObject0Data2 = var5_29.next_;
                }
            }
            if ((state_1 & 1) != 0 && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue)) {
                return this.foreignObject1Boundary(state_0, state_1, leftNodeValue, rightNodeValue);
            }
            if ((state_1 & 2) != 0 && JSIdenticalNodeGen.fallbackGuard_(state_0, state_1, leftNodeValue, rightNodeValue)) {
                return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullA1Boundary(int state_0, int state_1, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary nullA1_bInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue);
            boolean bl = JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, nullA1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullB1Boundary(int state_0, int state_1, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary nullB1_aInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue);
            boolean bl = JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, nullB1_aInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignObject1Boundary(int state_0, int state_1, Object leftNodeValue, Object rightNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_aInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue);
            InteropLibrary foreignObject1_bInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue);
            boolean bl = JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, foreignObject1_aInterop__, foreignObject1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        if ((state_0 & 0xFFFFFFFE) == 0 && (state_1 & 3) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
            return this.executeBoolean_int_int0(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xFFFFFFFD) == 0 && (state_1 & 3) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
            return this.executeBoolean_double_double1(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xFFFFFFFB) == 0 && (state_1 & 3) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
            return this.executeBoolean_boolean_boolean2(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xFFFFFFEF) == 0 && (state_1 & 3) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
            return this.executeBoolean_double3(state_0, state_1, frameValue);
        }
        if ((state_0 & 0xFFFFFFDF) == 0 && (state_1 & 3) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
            return this.executeBoolean_double4(state_0, state_1, frameValue);
        }
        return this.executeBoolean_generic5(state_0, state_1, frameValue);
    }

    private boolean executeBoolean_int_int0(int state_0, int state_1, VirtualFrame frameValue) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 1) != 0);
        return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double1(int state_0, int state_1, VirtualFrame frameValue) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state_1 & 0x38) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state_1 & 0x34) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state_1 & 0x2C) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state_1 & 0x380) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state_1 & 0x340) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state_1 & 0x2C0) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state_1 & 0x38) == 0 && (state_0 != 0 || (state_1 & 3) != 0) ? (Number)leftNodeValue_long : (Number)((state_1 & 0x34) == 0 && (state_0 != 0 || (state_1 & 3) != 0) ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean2(int state_0, int state_1, VirtualFrame frameValue) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double3(int state_0, int state_1, VirtualFrame frameValue) {
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state_1 & 0x380) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state_1 & 0x340) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state_1 & 0x2C0) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state_0 & 0x10) != 0);
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state_1 & 0x380) == 0 && (state_0 != 0 || (state_1 & 3) != 0) ? (Number)rightNodeValue_long : (Number)((state_1 & 0x340) == 0 && (state_0 != 0 || (state_1 & 3) != 0) ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private boolean executeBoolean_double4(int state_0, int state_1, VirtualFrame frameValue) {
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state_1 & 0x38) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state_1 & 0x34) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state_1 & 0x2C) == 0 && (state_0 != 0 || (state_1 & 3) != 0)) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state_0 & 0x20) != 0);
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state_1 & 0x38) == 0 && (state_0 != 0 || (state_1 & 3) != 0) ? (Number)leftNodeValue_long : (Number)((state_1 & 0x34) == 0 && (state_0 != 0 || (state_1 & 3) != 0) ? (Number)leftNodeValue_int : (Number)leftNodeValue_), rightNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullA1Boundary0(int state_0, int state_1, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary nullA1_bInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            boolean bl = JSIdenticalNode.doNullA(leftNodeValue_, rightNodeValue_, nullA1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean nullB1Boundary1(int state_0, int state_1, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary nullB1_aInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue_);
            boolean bl = JSIdenticalNode.doNullB(leftNodeValue_, rightNodeValue_, nullB1_aInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private boolean foreignObject1Boundary2(int state_0, int state_1, Object leftNodeValue_, Object rightNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_aInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue_);
            InteropLibrary foreignObject1_bInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue_);
            boolean bl = JSIdenticalNode.doForeignObject(leftNodeValue_, rightNodeValue_, foreignObject1_aInterop__, foreignObject1_bInterop__);
            return bl;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExplodeLoop
    private boolean executeBoolean_generic5(int state_0, int state_1, VirtualFrame frameValue) {
        Object rightNodeValue__;
        CharSequence leftNodeValue__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 1) != 0 && leftNodeValue_ instanceof Integer) {
            int n = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof Integer) {
                int rightNodeValue__2 = (Integer)rightNodeValue_;
                return JSIdenticalNode.doInt(n, rightNodeValue__2);
            }
        }
        if ((state_0 & 2) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue_)) {
                double rightNodeValue__3 = JSTypesGen.asImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue_);
                return this.doDouble(d, rightNodeValue__3);
            }
        }
        if ((state_0 & 4) != 0 && leftNodeValue_ instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__4 = (Boolean)rightNodeValue_;
                return JSIdenticalNode.doBoolean(bl, rightNodeValue__4);
            }
        }
        if ((state_0 & 0x18) != 0 && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if ((state_0 & 8) != 0 && rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__5 = (BigInt)rightNodeValue_;
                return JSIdenticalNode.doBigInt(bigInt, rightNodeValue__5);
            }
            if ((state_0 & 0x10) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue_)) {
                double rightNodeValue__6 = JSTypesGen.asImplicitDouble((state_1 & 0x3C0) >>> 6, rightNodeValue_);
                return JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue__6);
            }
        }
        if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((state_1 & 0x3C) >>> 2, leftNodeValue_);
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__7 = (BigInt)rightNodeValue_;
                return JSIdenticalNode.doDoubleBigInt(d, rightNodeValue__7);
            }
        }
        if ((state_0 & 0x1C0) != 0) {
            DynamicObject dynamicObject;
            if ((state_0 & 0xC0) != 0) {
                if ((state_0 & 0x40) != 0 && JSGuards.isUndefined(leftNodeValue_)) {
                    return JSIdenticalNode.doUndefinedA(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0x80) != 0 && JSGuards.isUndefined(rightNodeValue_)) {
                    return JSIdenticalNode.doUndefinedB(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0x100) != 0 && JSTypes.isDynamicObject(leftNodeValue_) && JSGuards.isJSObject(dynamicObject = (DynamicObject)leftNodeValue_)) {
                return JSIdenticalNode.doJSObjectA(dynamicObject, rightNodeValue_);
            }
        }
        if ((state_0 & 0x1FE00) != 0) {
            DynamicObject dynamicObject;
            if ((state_0 & 0x200) != 0 && JSTypes.isDynamicObject(rightNodeValue_) && JSGuards.isJSObject(dynamicObject = (DynamicObject)rightNodeValue_)) {
                return JSIdenticalNode.doJSObjectB(leftNodeValue_, dynamicObject);
            }
            if ((state_0 & 0x1FC00) != 0) {
                if ((state_0 & 0x400) != 0 && JSGuards.isJSNull(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                    return JSIdenticalNode.doNullNull(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0x800) != 0 && JSGuards.isJSNull(leftNodeValue_) && JSGuards.isUndefined(rightNodeValue_)) {
                    return JSIdenticalNode.doNullUndefined(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0x1000) != 0 && JSGuards.isUndefined(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                    return JSIdenticalNode.doUndefinedNull(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0x2000) != 0) {
                    void var6_14;
                    NullA0Data nullA0Data = this.nullA0_cache;
                    while (var6_14 != null) {
                        if (var6_14.bInterop_.accepts(rightNodeValue_) && JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isJSNull(rightNodeValue_) && !JSGuards.isUndefined(rightNodeValue_)) {
                            return JSIdenticalNode.doNullA(leftNodeValue_, rightNodeValue_, var6_14.bInterop_);
                        }
                        NullA0Data nullA0Data2 = var6_14.next_;
                    }
                }
                if ((state_0 & 0x4000) != 0 && JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isJSNull(rightNodeValue_) && !JSGuards.isUndefined(rightNodeValue_)) {
                    return this.nullA1Boundary0(state_0, state_1, leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 0x8000) != 0) {
                    void var6_17;
                    NullB0Data nullB0Data = this.nullB0_cache;
                    while (var6_17 != null) {
                        if (var6_17.aInterop_.accepts(leftNodeValue_) && !JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isUndefined(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                            return JSIdenticalNode.doNullB(leftNodeValue_, rightNodeValue_, var6_17.aInterop_);
                        }
                        NullB0Data nullB0Data2 = var6_17.next_;
                    }
                }
                if ((state_0 & 0x10000) != 0 && !JSGuards.isJSNull(leftNodeValue_) && !JSGuards.isUndefined(leftNodeValue_) && JSGuards.isJSNull(rightNodeValue_)) {
                    return this.nullB1Boundary1(state_0, state_1, leftNodeValue_, rightNodeValue_);
                }
            }
        }
        if ((state_0 & 0xE0000) != 0 && rightNodeValue_ instanceof JSLazyString) {
            JSLazyString jSLazyString = (JSLazyString)rightNodeValue_;
            if ((state_0 & 0x60000) != 0 && leftNodeValue_ instanceof JSLazyString) {
                leftNodeValue__ = (JSLazyString)leftNodeValue_;
                if ((state_0 & 0x20000) != 0 && JSGuards.isReferenceEquals(leftNodeValue__, jSLazyString)) {
                    return JSIdenticalNode.doLazyStringReference(leftNodeValue__, jSLazyString);
                }
                if ((state_0 & 0x40000) != 0) {
                    return JSIdenticalNode.doLazyString(leftNodeValue__, jSLazyString, this.flattenA, this.flattenB, this.sameLen);
                }
            }
            if ((state_0 & 0x80000) != 0 && JSTypesGen.isImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue_)) {
                leftNodeValue__ = JSTypesGen.asImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue_);
                return JSIdenticalNode.doStringLazyString((String)leftNodeValue__, jSLazyString, this.flattenB, this.sameLen);
            }
        }
        if ((state_0 & 0x700000) != 0 && JSTypesGen.isImplicitString((state_1 & 0xE000) >>> 13, rightNodeValue_)) {
            String string = JSTypesGen.asImplicitString((state_1 & 0xE000) >>> 13, rightNodeValue_);
            if ((state_0 & 0x100000) != 0 && leftNodeValue_ instanceof JSLazyString) {
                leftNodeValue__ = (JSLazyString)leftNodeValue_;
                return JSIdenticalNode.doLazyStringString(leftNodeValue__, string, this.flattenA, this.sameLen);
            }
            if ((state_0 & 0x600000) != 0 && JSTypesGen.isImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue_)) {
                leftNodeValue__ = JSTypesGen.asImplicitString((state_1 & 0x1C00) >>> 10, leftNodeValue_);
                if ((state_0 & 0x200000) != 0 && JSGuards.isReferenceEquals(leftNodeValue__, string)) {
                    return JSIdenticalNode.doStringIdentity((String)leftNodeValue__, string);
                }
                if ((state_0 & 0x400000) != 0) {
                    return JSIdenticalNode.doString((String)leftNodeValue__, string);
                }
            }
        }
        if ((state_0 & 0x800000) != 0 && leftNodeValue_ instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue_;
            if (rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return JSIdenticalNode.doSymbol(symbol, (Symbol)rightNodeValue__);
            }
        }
        if ((state_0 & 0x3F000000) != 0) {
            if ((state_0 & 0x1000000) != 0 && JSGuards.isBoolean(leftNodeValue_) != JSGuards.isBoolean(rightNodeValue_)) {
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x2000000) != 0 && JSGuards.isSymbol(leftNodeValue_) != JSGuards.isSymbol(rightNodeValue_)) {
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x4000000) != 0) {
                void var6_23;
                DifferentTypesCachedData differentTypesCachedData = this.differentTypesCached_cache;
                while (var6_23 != null) {
                    if (leftNodeValue_.getClass() == var6_23.cachedClassA_ && rightNodeValue_.getClass() == var6_23.cachedClassB_) {
                        assert (JSIdenticalNode.isNonObjectType(var6_23.cachedClassA_) || JSIdenticalNode.isNonObjectType(var6_23.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(var6_23.cachedClassA_, var6_23.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue_, rightNodeValue_, var6_23.cachedClassA_, var6_23.cachedClassB_);
                    }
                    DifferentTypesCachedData differentTypesCachedData2 = var6_23.next_;
                }
            }
            if ((state_0 & 0x8000000) != 0 && JSRuntime.isJavaNumber(leftNodeValue_) != JSRuntime.isJavaNumber(rightNodeValue_)) {
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x10000000) != 0 && JSRuntime.isString(leftNodeValue_) != JSRuntime.isString(rightNodeValue_)) {
                return JSIdenticalNode.doStringNotString(leftNodeValue_, rightNodeValue_);
            }
            if ((state_0 & 0x20000000) != 0) {
                void var6_26;
                NumberCachedData numberCachedData = this.numberCached_cache;
                while (var6_26 != null) {
                    assert (var6_26.cachedClassA_ != null);
                    assert (var6_26.cachedClassB_ != null);
                    if (leftNodeValue_.getClass() == var6_26.cachedClassA_ && rightNodeValue_.getClass() == var6_26.cachedClassB_) {
                        return this.doNumberCached(leftNodeValue_, rightNodeValue_, var6_26.cachedClassA_, var6_26.cachedClassB_);
                    }
                    NumberCachedData numberCachedData2 = var6_26.next_;
                }
            }
        }
        if ((state_0 & 0x40000000) != 0 && leftNodeValue_ instanceof Number) {
            Number number = (Number)leftNodeValue_;
            if (rightNodeValue_ instanceof Number) {
                rightNodeValue__ = (Number)rightNodeValue_;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue__)) {
                    return this.doNumber(number, (Number)rightNodeValue__);
                }
            }
        }
        if ((state_0 & Integer.MIN_VALUE) != 0 || (state_1 & 3) != 0) {
            if ((state_0 & Integer.MIN_VALUE) != 0) {
                void var6_30;
                ForeignObject0Data foreignObject0Data = this.foreignObject0_cache;
                while (var6_30 != null) {
                    if (var6_30.aInterop_.accepts(leftNodeValue_) && var6_30.bInterop_.accepts(rightNodeValue_) && JSRuntime.isForeignObject(leftNodeValue_) && JSRuntime.isForeignObject(rightNodeValue_)) {
                        return JSIdenticalNode.doForeignObject(leftNodeValue_, rightNodeValue_, var6_30.aInterop_, var6_30.bInterop_);
                    }
                    ForeignObject0Data foreignObject0Data2 = var6_30.next_;
                }
            }
            if ((state_1 & 1) != 0 && JSRuntime.isForeignObject(leftNodeValue_) && JSRuntime.isForeignObject(rightNodeValue_)) {
                return this.foreignObject1Boundary2(state_0, state_1, leftNodeValue_, rightNodeValue_);
            }
            if ((state_1 & 2) != 0 && JSIdenticalNodeGen.fallbackGuard_(state_0, state_1, leftNodeValue_, rightNodeValue_)) {
                return JSIdenticalNode.doFallback(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int n;
            CharSequence leftNodeValue_;
            boolean rightNodeValue_82;
            DynamicObject dynamicObject;
            DynamicObject dynamicObject2;
            int n2;
            int n3;
            int state_0 = this.state_0_;
            int state_1 = this.state_1_;
            int exclude = this.exclude_;
            if (leftNodeValue instanceof Integer) {
                int n4 = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_3 = (Integer)rightNodeValue;
                    this.state_0_ = state_0 |= 1;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doInt(n4, rightNodeValue_3);
                    return bl;
                }
            }
            if ((n3 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_4 = JSTypesGen.asImplicitDouble(n3, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_4 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state_1 |= n3 << 2;
                    this.state_0_ = state_0 |= 2;
                    this.state_1_ = state_1 |= doubleCast1 << 6;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doDouble(leftNodeValue_4, rightNodeValue_4);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_5 = (Boolean)rightNodeValue;
                    this.state_0_ = state_0 |= 4;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl2 = JSIdenticalNode.doBoolean(bl, rightNodeValue_5);
                    return bl2;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_6 = (BigInt)rightNodeValue;
                    this.state_0_ = state_0 |= 8;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doBigInt(bigInt, rightNodeValue_6);
                    return bl;
                }
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_7 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    this.state_0_ = state_0 |= 0x10;
                    this.state_1_ = state_1 |= doubleCast1 << 6;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue_7);
                    return bl;
                }
            }
            if ((n2 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_6 = JSTypesGen.asImplicitDouble(n2, leftNodeValue);
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_82 = (BigInt)rightNodeValue;
                    this.state_0_ = state_0 |= 0x20;
                    this.state_1_ = state_1 |= n2 << 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doDoubleBigInt(leftNodeValue_6, rightNodeValue_82);
                    return bl;
                }
            }
            if (JSGuards.isUndefined(leftNodeValue)) {
                this.state_0_ = state_0 |= 0x40;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedA(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isUndefined(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x80;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedB(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSTypes.isDynamicObject(leftNodeValue) && JSGuards.isJSObject(dynamicObject2 = (DynamicObject)leftNodeValue)) {
                this.state_0_ = state_0 |= 0x100;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_6 = JSIdenticalNode.doJSObjectA(dynamicObject2, rightNodeValue);
                return leftNodeValue_6;
            }
            if (JSTypes.isDynamicObject(rightNodeValue) && JSGuards.isJSObject(dynamicObject = (DynamicObject)rightNodeValue)) {
                this.state_0_ = state_0 |= 0x200;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean leftNodeValue_6 = JSIdenticalNode.doJSObjectB(leftNodeValue, dynamicObject);
                return leftNodeValue_6;
            }
            if (JSGuards.isJSNull(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x400;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNullNull(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isJSNull(leftNodeValue) && JSGuards.isUndefined(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x800;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNullUndefined(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x1000;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedNull(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 1) == 0) {
                void var8_21;
                boolean bl = false;
                NullA0Data s13_ = this.nullA0_cache;
                if ((state_0 & 0x2000) != 0) {
                    while (s13_ != null && (!s13_.bInterop_.accepts(rightNodeValue) || !JSGuards.isJSNull(leftNodeValue) || JSGuards.isJSNull(rightNodeValue) || JSGuards.isUndefined(rightNodeValue))) {
                        s13_ = s13_.next_;
                        ++var8_21;
                    }
                }
                if (s13_ == null && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue) && var8_21 < 5) {
                    s13_ = (NullA0Data)super.insert((Node)new NullA0Data(this.nullA0_cache));
                    s13_.bInterop_ = (InteropLibrary)s13_.insertAccessor(INTEROP_LIBRARY_.create(rightNodeValue));
                    MemoryFence.storeStore();
                    this.nullA0_cache = s13_;
                    this.state_0_ = state_0 |= 0x2000;
                    this.state_1_ = state_1;
                }
                if (s13_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_7 = JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, s13_.bInterop_);
                    return rightNodeValue_7;
                }
            }
            Object var8_22 = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_22 = encapsulating_.set((Node)this);
            try {
                if (JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
                    InteropLibrary interopLibrary = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue);
                    this.exclude_ = exclude |= 1;
                    this.nullA0_cache = null;
                    state_0 &= 0xFFFFDFFF;
                    this.state_0_ = state_0 |= 0x4000;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doNullA(leftNodeValue, rightNodeValue, interopLibrary);
                    return rightNodeValue_82;
                }
            }
            finally {
                encapsulating_.set(prev_22);
            }
            if ((exclude & 2) == 0) {
                void var8_25;
                boolean bl = false;
                NullB0Data s15_ = this.nullB0_cache;
                if ((state_0 & 0x8000) != 0) {
                    while (s15_ != null && (!s15_.aInterop_.accepts(leftNodeValue) || JSGuards.isJSNull(leftNodeValue) || JSGuards.isUndefined(leftNodeValue) || !JSGuards.isJSNull(rightNodeValue))) {
                        s15_ = s15_.next_;
                        ++var8_25;
                    }
                }
                if (s15_ == null && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue) && var8_25 < 5) {
                    s15_ = (NullB0Data)super.insert((Node)new NullB0Data(this.nullB0_cache));
                    s15_.aInterop_ = (InteropLibrary)s15_.insertAccessor(INTEROP_LIBRARY_.create(leftNodeValue));
                    MemoryFence.storeStore();
                    this.nullB0_cache = s15_;
                    this.state_0_ = state_0 |= 0x8000;
                    this.state_1_ = state_1;
                }
                if (s15_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean prev_22 = JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, s15_.aInterop_);
                    return prev_22;
                }
            }
            Object var8_26 = null;
            encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_32 = encapsulating_.set((Node)this);
            try {
                if (!JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
                    InteropLibrary interopLibrary = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue);
                    this.exclude_ = exclude |= 2;
                    this.nullB0_cache = null;
                    state_0 &= 0xFFFF7FFF;
                    this.state_0_ = state_0 |= 0x10000;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doNullB(leftNodeValue, rightNodeValue, interopLibrary);
                    return rightNodeValue_82;
                }
            }
            finally {
                encapsulating_.set(prev_32);
            }
            if (rightNodeValue instanceof JSLazyString) {
                JSLazyString jSLazyString = (JSLazyString)rightNodeValue;
                if (leftNodeValue instanceof JSLazyString) {
                    JSLazyString leftNodeValue_7 = (JSLazyString)leftNodeValue;
                    if ((exclude & 4) == 0 && JSGuards.isReferenceEquals(leftNodeValue_7, jSLazyString)) {
                        this.state_0_ = state_0 |= 0x20000;
                        this.state_1_ = state_1;
                        lock.unlock();
                        hasLock = false;
                        boolean prev_32 = JSIdenticalNode.doLazyStringReference(leftNodeValue_7, jSLazyString);
                        return prev_32;
                    }
                    this.flattenA = this.flattenA == null ? ConditionProfile.createBinaryProfile() : this.flattenA;
                    this.flattenB = this.flattenB == null ? ConditionProfile.createBinaryProfile() : this.flattenB;
                    this.sameLen = this.sameLen == null ? ConditionProfile.createBinaryProfile() : this.sameLen;
                    this.exclude_ = exclude |= 4;
                    state_0 &= 0xFFFDFFFF;
                    this.state_0_ = state_0 |= 0x40000;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    boolean prev_32 = JSIdenticalNode.doLazyString(leftNodeValue_7, jSLazyString, this.flattenA, this.flattenB, this.sameLen);
                    return prev_32;
                }
                int stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue);
                if (stringCast0 != 0) {
                    leftNodeValue_ = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                    this.flattenB = this.flattenB == null ? ConditionProfile.createBinaryProfile() : this.flattenB;
                    this.sameLen = this.sameLen == null ? ConditionProfile.createBinaryProfile() : this.sameLen;
                    this.state_0_ = state_0 |= 0x80000;
                    this.state_1_ = state_1 |= stringCast0 << 10;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doStringLazyString(leftNodeValue_, jSLazyString, this.flattenB, this.sameLen);
                    return rightNodeValue_82;
                }
            }
            if ((n = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                String rightNodeValue_10 = JSTypesGen.asImplicitString(n, rightNodeValue);
                if (leftNodeValue instanceof JSLazyString) {
                    leftNodeValue_ = (JSLazyString)leftNodeValue;
                    this.flattenA = this.flattenA == null ? ConditionProfile.createBinaryProfile() : this.flattenA;
                    this.sameLen = this.sameLen == null ? ConditionProfile.createBinaryProfile() : this.sameLen;
                    this.state_0_ = state_0 |= 0x100000;
                    this.state_1_ = state_1 |= n << 13;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_82 = JSIdenticalNode.doLazyStringString((JSLazyString)leftNodeValue_, rightNodeValue_10, this.flattenA, this.sameLen);
                    return rightNodeValue_82;
                }
                int stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue);
                if (stringCast0 != 0) {
                    String leftNodeValue_8 = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                    if ((exclude & 8) == 0 && JSGuards.isReferenceEquals(leftNodeValue_8, rightNodeValue_10)) {
                        state_1 |= stringCast0 << 10;
                        this.state_0_ = state_0 |= 0x200000;
                        this.state_1_ = state_1 |= n << 13;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JSIdenticalNode.doStringIdentity(leftNodeValue_8, rightNodeValue_10);
                        return bl;
                    }
                    this.exclude_ = exclude |= 8;
                    state_0 &= 0xFFDFFFFF;
                    state_1 |= stringCast0 << 10;
                    this.state_0_ = state_0 |= 0x400000;
                    this.state_1_ = state_1 |= n << 13;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doString(leftNodeValue_8, rightNodeValue_10);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Symbol) {
                Symbol bl = (Symbol)leftNodeValue;
                if (rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_11 = (Symbol)rightNodeValue;
                    this.state_0_ = state_0 |= 0x800000;
                    this.state_1_ = state_1;
                    lock.unlock();
                    hasLock = false;
                    boolean stringCast0 = JSIdenticalNode.doSymbol(bl, rightNodeValue_11);
                    return stringCast0;
                }
            }
            if (JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x1000000;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x2000000;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 0x10) == 0) {
                void var8_35;
                boolean bl = false;
                DifferentTypesCachedData s26_ = this.differentTypesCached_cache;
                if ((state_0 & 0x4000000) != 0) {
                    while (s26_ != null) {
                        if (leftNodeValue.getClass() == s26_.cachedClassA_ && rightNodeValue.getClass() == s26_.cachedClassB_) {
                            assert (JSIdenticalNode.isNonObjectType(s26_.cachedClassA_) || JSIdenticalNode.isNonObjectType(s26_.cachedClassB_));
                            assert (JSIdenticalNode.differentNonObjectTypes(s26_.cachedClassA_, s26_.cachedClassB_));
                            break;
                        }
                        s26_ = s26_.next_;
                        ++var8_35;
                    }
                }
                if (s26_ == null) {
                    Class<?> cachedClassA__ = leftNodeValue.getClass();
                    if (leftNodeValue.getClass() == cachedClassA__) {
                        Class<?> cachedClassB__ = rightNodeValue.getClass();
                        if (rightNodeValue.getClass() == cachedClassB__ && (JSIdenticalNode.isNonObjectType(cachedClassA__) || JSIdenticalNode.isNonObjectType(cachedClassB__)) && JSIdenticalNode.differentNonObjectTypes(cachedClassA__, cachedClassB__) && var8_35 < 3) {
                            s26_ = new DifferentTypesCachedData(this.differentTypesCached_cache);
                            s26_.cachedClassA_ = cachedClassA__;
                            s26_.cachedClassB_ = cachedClassB__;
                            MemoryFence.storeStore();
                            this.differentTypesCached_cache = s26_;
                            this.state_0_ = state_0 |= 0x4000000;
                            this.state_1_ = state_1;
                        }
                    }
                }
                if (s26_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__ = JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, s26_.cachedClassA_, s26_.cachedClassB_);
                    return cachedClassA__;
                }
            }
            if (JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
                this.exclude_ = exclude |= 0x10;
                this.differentTypesCached_cache = null;
                state_0 &= 0xFBFFFFFF;
                this.state_0_ = state_0 |= 0x8000000;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
                this.exclude_ = exclude |= 0x10;
                this.differentTypesCached_cache = null;
                state_0 &= 0xFBFFFFFF;
                this.state_0_ = state_0 |= 0x10000000;
                this.state_1_ = state_1;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 0x20) == 0) {
                Class<? extends Number> cachedClassB__1;
                Class<? extends Number> cachedClassA__122;
                void var8_39;
                boolean bl = false;
                NumberCachedData s29_ = this.numberCached_cache;
                if ((state_0 & 0x20000000) != 0) {
                    while (s29_ != null) {
                        assert (s29_.cachedClassA_ != null);
                        assert (s29_.cachedClassB_ != null);
                        if (leftNodeValue.getClass() == s29_.cachedClassA_ && rightNodeValue.getClass() == s29_.cachedClassB_) break;
                        s29_ = s29_.next_;
                        ++var8_39;
                    }
                }
                if (s29_ == null && (cachedClassA__122 = JSGuards.getJavaNumberClass(leftNodeValue)) != null && (cachedClassB__1 = JSGuards.getJavaNumberClass(rightNodeValue)) != null && leftNodeValue.getClass() == cachedClassA__122 && rightNodeValue.getClass() == cachedClassB__1 && var8_39 < 3) {
                    s29_ = new NumberCachedData(this.numberCached_cache);
                    s29_.cachedClassA_ = cachedClassA__122;
                    s29_.cachedClassB_ = cachedClassB__1;
                    MemoryFence.storeStore();
                    this.numberCached_cache = s29_;
                    this.state_0_ = state_0 |= 0x20000000;
                    this.state_1_ = state_1;
                }
                if (s29_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__122 = this.doNumberCached(leftNodeValue, rightNodeValue, s29_.cachedClassA_, s29_.cachedClassB_);
                    return cachedClassA__122;
                }
            }
            if (leftNodeValue instanceof Number) {
                Number number = (Number)leftNodeValue;
                if (rightNodeValue instanceof Number) {
                    Number rightNodeValue_12 = (Number)rightNodeValue;
                    if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_12)) {
                        this.exclude_ = exclude |= 0x20;
                        this.numberCached_cache = null;
                        state_0 &= 0xDFFFFFFF;
                        this.state_0_ = state_0 |= 0x40000000;
                        this.state_1_ = state_1;
                        lock.unlock();
                        hasLock = false;
                        boolean cachedClassA__122 = this.doNumber(number, rightNodeValue_12);
                        return cachedClassA__122;
                    }
                }
            }
            if ((exclude & 0x40) == 0) {
                void var8_42;
                boolean bl = false;
                ForeignObject0Data s31_ = this.foreignObject0_cache;
                if ((state_0 & Integer.MIN_VALUE) != 0) {
                    while (!(s31_ == null || s31_.aInterop_.accepts(leftNodeValue) && s31_.bInterop_.accepts(rightNodeValue) && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue))) {
                        s31_ = s31_.next_;
                        ++var8_42;
                    }
                }
                if (s31_ == null && JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue) && var8_42 < 5) {
                    s31_ = (ForeignObject0Data)super.insert((Node)new ForeignObject0Data(this.foreignObject0_cache));
                    s31_.aInterop_ = (InteropLibrary)s31_.insertAccessor(INTEROP_LIBRARY_.create(leftNodeValue));
                    s31_.bInterop_ = (InteropLibrary)s31_.insertAccessor(INTEROP_LIBRARY_.create(rightNodeValue));
                    MemoryFence.storeStore();
                    this.foreignObject0_cache = s31_;
                    this.state_0_ = state_0 |= Integer.MIN_VALUE;
                    this.state_1_ = state_1;
                }
                if (s31_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__122 = JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, s31_.aInterop_, s31_.bInterop_);
                    return cachedClassA__122;
                }
            }
            Object var8_43 = null;
            InteropLibrary foreignObject1_aInterop__ = null;
            EncapsulatingNodeReference encapsulating_2 = EncapsulatingNodeReference.getCurrent();
            Node prev_4 = encapsulating_2.set((Node)this);
            try {
                if (JSRuntime.isForeignObject(leftNodeValue) && JSRuntime.isForeignObject(rightNodeValue)) {
                    foreignObject1_aInterop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(leftNodeValue);
                    InteropLibrary interopLibrary = (InteropLibrary)INTEROP_LIBRARY_.getUncached(rightNodeValue);
                    this.exclude_ = exclude |= 0x40;
                    this.foreignObject0_cache = null;
                    this.state_0_ = state_0 &= Integer.MAX_VALUE;
                    this.state_1_ = state_1 |= 1;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doForeignObject(leftNodeValue, rightNodeValue, foreignObject1_aInterop__, interopLibrary);
                    return bl;
                }
            }
            finally {
                encapsulating_2.set(prev_4);
            }
            this.state_0_ = state_0;
            this.state_1_ = state_1 |= 2;
            lock.unlock();
            hasLock = false;
            boolean bl = JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        if (state_0 == 0 && (state_1 & 3) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        int counter = 0;
        counter += Integer.bitCount(state_0);
        if ((counter += Integer.bitCount(state_1 & 3)) == 1) {
            NullA0Data s13_ = this.nullA0_cache;
            NullB0Data s15_ = this.nullB0_cache;
            DifferentTypesCachedData s26_ = this.differentTypesCached_cache;
            NumberCachedData s29_ = this.numberCached_cache;
            ForeignObject0Data s31_ = this.foreignObject0_cache;
            if (!(s13_ != null && s13_.next_ != null || s15_ != null && s15_.next_ != null || s26_ != null && s26_.next_ != null || s29_ != null && s29_.next_ != null || s31_ != null && s31_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[35];
        data[0] = 0;
        int state_0 = this.state_0_;
        int state_1 = this.state_1_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigIntDouble";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleBigInt";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doUndefinedA";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doUndefinedB";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObjectA";
        s[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObjectB";
        s[1] = (state_0 & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doNullNull";
        s[1] = (state_0 & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "doNullUndefined";
        s[1] = (state_0 & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "doUndefinedNull";
        s[1] = (state_0 & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doNullA";
        if ((state_0 & 0x2000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            NullA0Data s13_ = this.nullA0_cache;
            while (s13_ != null) {
                cached.add(Arrays.asList(s13_.bInterop_));
                s13_ = s13_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[14] = s;
        s = new Object[3];
        s[0] = "doNullA";
        if ((state_0 & 0x4000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[0]));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[15] = s;
        s = new Object[3];
        s[0] = "doNullB";
        if ((state_0 & 0x8000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            NullB0Data s15_ = this.nullB0_cache;
            while (s15_ != null) {
                cached.add(Arrays.asList(s15_.aInterop_));
                s15_ = s15_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[16] = s;
        s = new Object[3];
        s[0] = "doNullB";
        if ((state_0 & 0x10000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[0]));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[17] = s;
        s = new Object[3];
        s[0] = "doLazyStringReference";
        s[1] = (state_0 & 0x20000) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[18] = s;
        s = new Object[3];
        s[0] = "doLazyString";
        if ((state_0 & 0x40000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.flattenA, this.flattenB, this.sameLen));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[19] = s;
        s = new Object[3];
        s[0] = "doStringLazyString";
        if ((state_0 & 0x80000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.flattenB, this.sameLen));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[20] = s;
        s = new Object[3];
        s[0] = "doLazyStringString";
        if ((state_0 & 0x100000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.flattenA, this.sameLen));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[21] = s;
        s = new Object[3];
        s[0] = "doStringIdentity";
        s[1] = (state_0 & 0x200000) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[22] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state_0 & 0x400000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[23] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state_0 & 0x800000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[24] = s;
        s = new Object[3];
        s[0] = "doBooleanNotBoolean";
        s[1] = (state_0 & 0x1000000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[25] = s;
        s = new Object[3];
        s[0] = "doSymbolNotSymbol";
        s[1] = (state_0 & 0x2000000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[26] = s;
        s = new Object[3];
        s[0] = "doDifferentTypesCached";
        if ((state_0 & 0x4000000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            DifferentTypesCachedData s26_ = this.differentTypesCached_cache;
            while (s26_ != null) {
                cached.add(Arrays.asList(s26_.cachedClassA_, s26_.cachedClassB_));
                s26_ = s26_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[27] = s;
        s = new Object[3];
        s[0] = "doNumberNotNumber";
        s[1] = (state_0 & 0x8000000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[28] = s;
        s = new Object[3];
        s[0] = "doStringNotString";
        s[1] = (state_0 & 0x10000000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[29] = s;
        s = new Object[3];
        s[0] = "doNumberCached";
        if ((state_0 & 0x20000000) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            NumberCachedData s29_ = this.numberCached_cache;
            while (s29_ != null) {
                cached.add(Arrays.asList(s29_.cachedClassA_, s29_.cachedClassB_));
                s29_ = s29_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x20) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[30] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state_0 & 0x40000000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[31] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & Integer.MIN_VALUE) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            ForeignObject0Data s31_ = this.foreignObject0_cache;
            while (s31_ != null) {
                cached.add(Arrays.asList(s31_.aInterop_, s31_.bInterop_));
                s31_ = s31_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 0x40) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[32] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_1 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new Object[0]));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[33] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state_1 & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[34] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state_0, int state_1, Object leftNodeValue, Object rightNodeValue) {
        Number rightNodeValue_;
        DynamicObject rightNodeValue_2;
        Object leftNodeValue_;
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 4) == 0 && leftNodeValue instanceof Boolean && rightNodeValue instanceof Boolean) {
            return false;
        }
        if (leftNodeValue instanceof BigInt) {
            if ((state_0 & 8) == 0 && rightNodeValue instanceof BigInt) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if ((state_0 & 0x40) == 0 && JSGuards.isUndefined(leftNodeValue)) {
            return false;
        }
        if ((state_0 & 0x80) == 0 && JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if (JSTypes.isDynamicObject(leftNodeValue) && JSGuards.isJSObject(leftNodeValue_ = (DynamicObject)leftNodeValue)) {
            return false;
        }
        if (JSTypes.isDynamicObject(rightNodeValue) && JSGuards.isJSObject(rightNodeValue_2 = (DynamicObject)rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x400) == 0 && JSGuards.isJSNull(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x800) == 0 && JSGuards.isJSNull(leftNodeValue) && JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x1000) == 0 && JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x4000) == 0 && JSGuards.isJSNull(leftNodeValue) && !JSGuards.isJSNull(rightNodeValue) && !JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x10000) == 0 && !JSGuards.isJSNull(leftNodeValue) && !JSGuards.isUndefined(leftNodeValue) && JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitString(leftNodeValue) && JSTypesGen.isImplicitString(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x800000) == 0 && leftNodeValue instanceof Symbol && rightNodeValue instanceof Symbol) {
            return false;
        }
        if ((state_0 & 0x1000000) == 0 && JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x2000000) == 0 && JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x8000000) == 0 && JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
            return false;
        }
        if ((state_0 & 0x10000000) == 0 && JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
            return false;
        }
        if (leftNodeValue instanceof Number && rightNodeValue instanceof Number && JSRuntime.isJavaNumber(leftNodeValue_ = (Number)leftNodeValue) && JSRuntime.isJavaNumber(rightNodeValue_ = (Number)rightNodeValue)) {
            return false;
        }
        return (state_1 & 1) != 0 || !JSRuntime.isForeignObject(leftNodeValue) || !JSRuntime.isForeignObject(rightNodeValue);
    }

    public static JSIdenticalNode create(JavaScriptNode left, JavaScriptNode right, int type) {
        return new JSIdenticalNodeGen(left, right, type);
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary aInterop_;
        @Node.Child
        InteropLibrary bInterop_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NumberCachedData {
        @CompilerDirectives.CompilationFinal
        NumberCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        NumberCachedData(NumberCachedData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class DifferentTypesCachedData {
        @CompilerDirectives.CompilationFinal
        DifferentTypesCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        DifferentTypesCachedData(DifferentTypesCachedData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NullB0Data
    extends Node {
        @Node.Child
        NullB0Data next_;
        @Node.Child
        InteropLibrary aInterop_;

        NullB0Data(NullB0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NullA0Data
    extends Node {
        @Node.Child
        NullA0Data next_;
        @Node.Child
        InteropLibrary bInterop_;

        NullA0Data(NullA0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

