/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.PluralRulesPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;

public final class PluralRulesPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<PluralRulesPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new PluralRulesPrototypeBuiltins();

    protected PluralRulesPrototypeBuiltins() {
        super("PluralRules.prototype", PluralRulesPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, PluralRulesPrototype builtinEnum) {
        switch (builtinEnum) {
            case resolvedOptions: {
                return PluralRulesPrototypeBuiltinsFactory.JSPluralRulesResolvedOptionsNodeGen.create(context, builtin, PluralRulesPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case select: {
                return PluralRulesPrototypeBuiltinsFactory.JSPluralRulesSelectNodeGen.create(context, builtin, PluralRulesPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSPluralRulesSelectNode
    extends JSBuiltinNode {
        public JSPluralRulesSelectNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSPluralRules(pluralRules)"})
        public Object doSelect(DynamicObject pluralRules, Object value) {
            return JSPluralRules.select(pluralRules, value);
        }

        @Fallback
        public void throwTypeError(Object bummer, Object value) {
            throw Errors.createTypeErrorTypeXExpected("PluralRules");
        }
    }

    public static abstract class JSPluralRulesResolvedOptionsNode
    extends JSBuiltinNode {
        public JSPluralRulesResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSPluralRules(pluralRules)"})
        public Object doResolvedOptions(DynamicObject pluralRules) {
            return JSPluralRules.resolvedOptions(this.getContext(), this.getRealm(), pluralRules);
        }

        @Fallback
        public void doResolvedOptions(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected("PluralRules");
        }
    }

    public static enum PluralRulesPrototype implements BuiltinEnum<PluralRulesPrototype>
    {
        resolvedOptions(0),
        select(1);

        private final int length;

        private PluralRulesPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

