/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.commonjs.CommonJSRequireBuiltin;
import com.oracle.truffle.js.builtins.commonjs.CommonJSResolution;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;

public abstract class CommonJSResolveBuiltin
extends GlobalBuiltins.JSFileLoadingOperation {
    CommonJSResolveBuiltin(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected String resolve(String moduleIdentifier) {
        TruffleFile cwd;
        JSRealm realm = this.getRealm();
        TruffleFile maybeModule = CommonJSResolution.resolve(realm, moduleIdentifier, cwd = CommonJSRequireBuiltin.getModuleResolveCurrentWorkingDirectory(this.getContext(), realm.getEnv()));
        if (maybeModule == null) {
            throw CommonJSResolveBuiltin.fail(moduleIdentifier);
        }
        return maybeModule.getAbsoluteFile().normalize().toString();
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException fail(String moduleIdentifier) {
        return JSException.create(JSErrorType.TypeError, "Cannot find module: '" + moduleIdentifier + "'");
    }
}

