/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.crypto;

import com.paterva.maltego.crypto.AsymmetricPublicKey;
import com.paterva.maltego.crypto.ClientCryptographer;
import com.paterva.maltego.crypto.CryptoConfig;
import java.security.GeneralSecurityException;
import org.openide.util.Exceptions;

public class MaltegoClientCryptographer
extends ClientCryptographer {
    private static final MaltegoClientCryptographer INSTANCE = MaltegoClientCryptographer.createInstance();
    private static final String ASYMMETRIC_TRANSFORMATION = "RSA/ECB/OAEPWithSHA1AndMGF1Padding";
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final String SYMMETRIC_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final int SYMMETRIC_KEY_SIZE = 128;
    private static final String VERIFICATION_ALGORITHM = "SHA256withRSA";
    private static final String HASH_ALGORITHM = "SHA-256";

    private MaltegoClientCryptographer() throws GeneralSecurityException {
        super(new CryptoConfig(AsymmetricPublicKey.get(), ASYMMETRIC_TRANSFORMATION, SYMMETRIC_ALGORITHM, SYMMETRIC_TRANSFORMATION, 128, VERIFICATION_ALGORITHM, HASH_ALGORITHM));
    }

    public static MaltegoClientCryptographer getInstance() {
        return INSTANCE;
    }

    private static MaltegoClientCryptographer createInstance() {
        MaltegoClientCryptographer instance = null;
        try {
            instance = new MaltegoClientCryptographer();
        }
        catch (GeneralSecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return instance;
    }
}

