/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.crypto;

import com.paterva.maltego.crypto.AsymmetricEncryptor;
import com.paterva.maltego.crypto.AsymmetricVerifier;
import com.paterva.maltego.crypto.CryptoConfig;
import com.paterva.maltego.crypto.HashGenerator;
import com.paterva.maltego.crypto.PayloadEncryptor;
import com.paterva.maltego.crypto.SymmetricDecryptor;
import com.paterva.maltego.crypto.SymmetricEncryptor;
import com.paterva.maltego.crypto.payload.AsymmetricPayload;
import com.paterva.maltego.crypto.payload.EncryptedKeyAndIv;
import com.paterva.maltego.crypto.payload.PlainKeyAndIv;
import com.paterva.maltego.crypto.payload.SymmetricPayload;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ClientCryptographer
implements PayloadEncryptor,
AsymmetricEncryptor,
SymmetricEncryptor,
SymmetricDecryptor,
AsymmetricVerifier,
HashGenerator {
    private final CryptoConfig config;

    public ClientCryptographer(CryptoConfig config) {
        this.config = config;
    }

    public CryptoConfig getConfig() {
        return this.config;
    }

    @Override
    public AsymmetricPayload encryptSymmetricAndAsymmetric(byte[] bytes) throws GeneralSecurityException {
        SymmetricPayload payload = this.encryptSymmetric(bytes);
        PlainKeyAndIv plainKeyAndIv = payload.getPlainKeyAndIv();
        byte[] key = this.encryptAsymmetric(plainKeyAndIv.getKey());
        byte[] iv = this.encryptAsymmetric(plainKeyAndIv.getIv());
        return new AsymmetricPayload(payload, new EncryptedKeyAndIv(key, iv));
    }

    @Override
    public byte[] encryptAsymmetric(byte[] plainText) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(this.config.getAsymmetricTransformation());
        cipher.init(1, this.config.getPublicKey());
        return cipher.doFinal(plainText);
    }

    public SecretKey generateSymmetricKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGen = KeyGenerator.getInstance(this.config.getSymmetricAlgorithm());
        keyGen.init(this.config.getSymmetricKeySize());
        return keyGen.generateKey();
    }

    @Override
    public SymmetricPayload encryptSymmetric(byte[] bytes) throws GeneralSecurityException {
        SecretKey secretKey = this.generateSymmetricKey();
        Cipher cipher = Cipher.getInstance(this.config.getSymmetricTransformation());
        cipher.init(1, secretKey);
        byte[] key = secretKey.getEncoded();
        byte[] iv = cipher.getIV();
        byte[] cipherText = cipher.doFinal(bytes);
        return new SymmetricPayload(new PlainKeyAndIv(key, iv), cipherText);
    }

    @Override
    public byte[] decryptSymmetric(SymmetricPayload encrypted) throws GeneralSecurityException {
        PlainKeyAndIv plainKeyAndIv = encrypted.getPlainKeyAndIv();
        byte[] key = plainKeyAndIv.getKey();
        byte[] iv = plainKeyAndIv.getIv();
        byte[] cipherText = encrypted.getCipherText();
        SecretKeySpec secretKey = new SecretKeySpec(key, this.config.getSymmetricAlgorithm());
        Cipher cipher = Cipher.getInstance(this.config.getSymmetricTransformation());
        cipher.init(2, (Key)secretKey, new IvParameterSpec(iv));
        return cipher.doFinal(cipherText);
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws GeneralSecurityException {
        Signature sig = Signature.getInstance(this.config.getVerificationAlgorithm());
        sig.initVerify(this.config.getPublicKey());
        sig.update(data);
        return sig.verify(signature);
    }

    @Override
    public byte[] getHash(byte[] bytes) throws GeneralSecurityException {
        MessageDigest digest = MessageDigest.getInstance(this.config.getHashAlgorithm());
        return digest.digest(bytes);
    }
}

