/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.ex;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigComparator;
import com.paterva.maltego.importexport.ConfigExporter;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.importexport.wizard.ex.ExportWizardIterator;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.openide.WizardDescriptor;
import org.openide.util.NbPreferences;

public class ExportWizard {
    public static WizardDescriptor create(ConfigExporter[] exporters, Map<String, String> descriptionAndIcons) {
        String WIZARD_TITLE = "Export Wizard";
        ExportWizardIterator wizardIterator = new ExportWizardIterator();
        WizardDescriptor wizardDescriptor = new WizardDescriptor(wizardIterator);
        wizardDescriptor.setTitleFormat(new MessageFormat("Export Wizard - {0}"));
        wizardDescriptor.setTitle("Export Wizard");
        ExportWizard.initializeProperties(wizardDescriptor, exporters, descriptionAndIcons);
        wizardIterator.initialize(wizardDescriptor);
        return wizardDescriptor;
    }

    private static void initializeProperties(WizardDescriptor wizardDescriptor, ConfigExporter[] exporters, Map<String, String> descriptionAndIcons) {
        TreeMap<Config, ConfigExporter> configsMap = new TreeMap<Config, ConfigExporter>(new ConfigComparator());
        for (ConfigExporter configExporter : exporters) {
            Config config = configExporter.getCurrentConfig();
            if (config == null) continue;
            configsMap.put(config, configExporter);
        }
        wizardDescriptor.putProperty("WizardPanel_helpDisplayed", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("selectEverything", (Object)Boolean.TRUE);
        wizardDescriptor.putProperty("encrypt", (Object)Boolean.FALSE);
        wizardDescriptor.putProperty("configsMap", configsMap);
        wizardDescriptor.putProperty("allConfigs", (Object)new AllConfigsNode(configsMap.keySet(), false));
        wizardDescriptor.putProperty("browseDir", (Object)NbPreferences.root().get("browseDir", ""));
        for (Map.Entry entry : descriptionAndIcons.entrySet()) {
            wizardDescriptor.putProperty((String)entry.getKey(), entry.getValue());
        }
    }
}

