/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.previous;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigComparator;
import com.paterva.maltego.importexport.ConfigFileSystem;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.util.NormalException;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class PreviousConfigs {
    public static FileObject createConfigRoot(File prevConfDir) throws IOException, PropertyVetoException {
        ConfigFileSystem fs = new ConfigFileSystem();
        fs.setRootDirectory(prevConfDir);
        fs.setReadOnly(true);
        return fs.getRoot();
    }

    public static TreeMap<Config, ConfigImporter> loadConfigs(ConfigImporter[] importers, FileObject configRoot) {
        TreeMap<Config, ConfigImporter> configsMap = new TreeMap<Config, ConfigImporter>(new ConfigComparator());
        for (ConfigImporter importer : importers) {
            try {
                Config config = importer.loadPreviousConfig(configRoot);
                if (config == null) continue;
                configsMap.put(config, importer);
            }
            catch (UnsupportedOperationException ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return configsMap;
    }
}

