/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy.windows;

import com.sun.jna.Pointer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core2.network.proxy.NetworkProxyResolver;
import org.netbeans.core2.network.proxy.NetworkProxySettings;
import org.netbeans.core2.network.proxy.WPADUtils;
import org.netbeans.core2.network.proxy.windows.WindowsNetworkProxyLibrary;

public class WindowsNetworkProxy
implements NetworkProxyResolver {
    private static final Logger LOGGER = Logger.getLogger(WindowsNetworkProxy.class.getName());
    private static final String HTTP_PROPERTY_NAME = "http=";
    private static final String HTTPS_PROPERTY_NAME = "https=";
    private static final String SOCKS_PROPERTY_NAME = "socks=";
    private static final String SPACE = " ";
    private static final String COLON = ":";
    private static final String SEMI_COLON = ";";

    @Override
    public NetworkProxySettings getNetworkProxySettings() {
        LOGGER.log(Level.FINE, "Windows system proxy resolver started.");
        WindowsNetworkProxyLibrary.ProxyConfig.ByReference prxCnf = new WindowsNetworkProxyLibrary.ProxyConfig.ByReference();
        boolean result = WindowsNetworkProxyLibrary.LIBRARY.WinHttpGetIEProxyConfigForCurrentUser(prxCnf);
        if (result) {
            String pacFileUrl;
            Pointer pacFilePointer;
            LOGGER.log(Level.FINE, "Windows system proxy resolver successfully retrieved proxy config settings : " + prxCnf.toString());
            if (prxCnf.autoDetect) {
                LOGGER.log(Level.INFO, "Windows system proxy resolver: auto detect");
                String wpadURL = WPADUtils.locateConfig();
                if (wpadURL != null) {
                    return new NetworkProxySettings(wpadURL);
                }
                LOGGER.log(Level.FINE, "Proxy settings to set auto-detect but no PAC file could be located using DNS. Next step is to see if the location of the PAC file has been explicitly configured");
            }
            if ((pacFilePointer = prxCnf.pacFile) != null && (pacFileUrl = pacFilePointer.getWideString(0L)) != null && !pacFileUrl.isEmpty()) {
                LOGGER.log(Level.INFO, "Windows system proxy resolver: auto - PAC ({0})", pacFileUrl);
                return new NetworkProxySettings(pacFileUrl);
            }
            Pointer proxyPointer = prxCnf.proxy;
            Pointer proxyBypassPointer = prxCnf.proxyBypass;
            if (proxyPointer != null) {
                String[] noProxyHosts;
                String proxyString = proxyPointer.getWideString(0L);
                LOGGER.log(Level.INFO, "Windows system proxy resolver: manual ({0})", proxyString);
                String httpProxy = null;
                String httpsProxy = null;
                String socksProxy = null;
                if (proxyString != null) {
                    proxyString = proxyString.toLowerCase();
                }
                if (proxyString.contains(SEMI_COLON)) {
                    String[] proxies;
                    for (String singleProxy : proxies = proxyString.split(SEMI_COLON)) {
                        if (singleProxy.startsWith(HTTP_PROPERTY_NAME)) {
                            httpProxy = singleProxy.substring(HTTP_PROPERTY_NAME.length());
                            continue;
                        }
                        if (singleProxy.startsWith(HTTPS_PROPERTY_NAME)) {
                            httpsProxy = singleProxy.substring(HTTPS_PROPERTY_NAME.length());
                            continue;
                        }
                        if (!singleProxy.startsWith(SOCKS_PROPERTY_NAME)) continue;
                        socksProxy = singleProxy.substring(SOCKS_PROPERTY_NAME.length());
                    }
                } else if (proxyString.startsWith(HTTP_PROPERTY_NAME)) {
                    proxyString = proxyString.substring(HTTP_PROPERTY_NAME.length());
                    httpProxy = proxyString.replace(SPACE, COLON);
                } else if (proxyString.startsWith(HTTPS_PROPERTY_NAME)) {
                    proxyString = proxyString.substring(HTTPS_PROPERTY_NAME.length());
                    httpsProxy = proxyString.replace(SPACE, COLON);
                } else if (proxyString.startsWith(SOCKS_PROPERTY_NAME)) {
                    proxyString = proxyString.substring(SOCKS_PROPERTY_NAME.length());
                    socksProxy = proxyString.replace(SPACE, COLON);
                } else {
                    httpProxy = proxyString;
                    httpsProxy = proxyString;
                }
                if (proxyBypassPointer != null) {
                    String proxyBypass = proxyBypassPointer.getWideString(0L);
                    LOGGER.log(Level.INFO, "Windows system proxy resolver: manual - no proxy hosts ({0})", proxyBypass);
                    noProxyHosts = proxyBypass.split(SEMI_COLON);
                } else {
                    noProxyHosts = new String[]{};
                }
                return new NetworkProxySettings(httpProxy, httpsProxy, socksProxy, noProxyHosts);
            }
            LOGGER.log(Level.FINE, "Windows system proxy resolver: no proxy");
            return new NetworkProxySettings();
        }
        LOGGER.log(Level.SEVERE, "Windows system proxy resolver cannot retrieve proxy settings from Windows API!");
        return new NetworkProxySettings(false);
    }
}

