/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaButtonUI;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.ReflectionUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import javax.swing.text.View;

public class DarculaModToggleButtonUI
extends MetalToggleButtonUI {
    public static final String IN_HUB_PANEL = "inHubPanel";
    public static final String IN_HOME_PANEL = "inHomePanel";
    public static final String SELECT_BG = "toggleButtonSelectBg";

    public static ComponentUI createUI(JComponent b) {
        return new DarculaModToggleButtonUI();
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension preferredSize = super.getPreferredSize(c);
        if (DarculaButtonUI.isToolBarForParent(c) && !this.isPalette(c)) {
            preferredSize.height -= 4;
            AbstractButton b = (AbstractButton)c;
            if (b.getText() == null || b.getText().isEmpty()) {
                preferredSize.width -= 4;
            }
            if (SystemInfo.isLinux && preferredSize.width > 0) {
                preferredSize.width += 8;
            }
        }
        return preferredSize;
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = b.getSize();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (this.isPalette(b)) {
            if (!(!model.isRollover() || model.isArmed() && model.isPressed() || model.isSelected())) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("palette-item-name-hovered-bg"));
            } else {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("palette-item-name-bg"));
            }
            if (!(b.getBorder() instanceof EmptyBorder)) {
                b.setBorder(new EmptyBorder(b.getInsets()));
            }
        } else if (DarculaModToggleButtonUI.isInHomePanel(c)) {
            if (model.isRollover()) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("home-toggle-focus-bg"));
            } else if (model.isArmed() && model.isPressed() || model.isSelected()) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("home-toggle-select-bg"));
            } else {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("home-toggle-bg"));
            }
        } else if (!(!model.isRollover() || model.isArmed() && model.isPressed() || model.isSelected())) {
            if (DarculaModToggleButtonUI.isInHubPanel(c)) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("hub-toggle-focus-bg"));
            } else {
                g.setColor(this.getFocusColor());
            }
        } else {
            g.setColor(b.getBackground());
        }
        if ((model.isArmed() && model.isPressed() || model.isSelected()) && (!DarculaModToggleButtonUI.isInHomePanel(c) || !model.isRollover())) {
            this.paintButtonPressed(g, b);
        } else {
            this.paintButton(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            GraphicsUtil.setupTextAntialiasing(g, c);
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintButton(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            if (this.isPalette(b)) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("palette-item-name-selected-bg"));
            } else {
                String selectBg = (String)b.getClientProperty(SELECT_BG);
                if (selectBg != null) {
                    g.setColor(UIManager.getLookAndFeelDefaults().getColor(selectBg));
                } else {
                    g.setColor(this.getSelectColor());
                }
            }
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
        }
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics(b.getFont());
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            if (model.isSelected() && DarculaModToggleButtonUI.isInHubPanel(c)) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("hub-toggle-select-fg"));
            } else if (model.isRollover() && DarculaModToggleButtonUI.isInHubPanel(c)) {
                g.setColor(UIManager.getLookAndFeelDefaults().getColor("hub-toggle-select-fg"));
            } else {
                g.setColor(b.getForeground());
            }
        } else if (model.isSelected()) {
            g.setColor(c.getBackground());
        } else {
            g.setColor(this.getDisabledTextColor());
        }
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }

    @Override
    public void update(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        this.paint(g, c);
        if (b.getIcon() == null && !this.isSlideBar() && !DarculaModToggleButtonUI.isInHubPanel(c)) {
            this.paintBorder(g, c);
        }
    }

    private boolean isPalette(JComponent b) {
        Container j = b.getParent();
        return j != null && j.getClass().getName().startsWith("org.netbeans.modules.palette.ui");
    }

    private boolean isSlideBar() {
        Class c1 = ReflectionUtil.findCallerClass(5);
        if (c1 != null) {
            if (c1.getName().endsWith("SlidingButtonUI")) {
                return true;
            }
            c1 = ReflectionUtil.findCallerClass(6);
            if (c1 != null && c1.getName().endsWith("SlidingButtonUI")) {
                return true;
            }
        }
        return false;
    }

    private void paintBorder(Graphics g, JComponent c) {
        Color old = g.getColor();
        if (DarculaModToggleButtonUI.isInHomePanel(c)) {
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("editor-tab-home-toggle-border-color"));
            g.drawRect(0, 0, c.getWidth(), c.getHeight());
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight());
        } else {
            g.setColor(UIManager.getLookAndFeelDefaults().getColor("ToggleButton.darculaMod.borderColor"));
            g.drawRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        }
        g.setColor(old);
    }

    private static boolean isInHubPanel(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IN_HUB_PANEL));
    }

    private static boolean isInHomePanel(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IN_HOME_PANEL));
    }
}

