/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run;

import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.io.TabularGraphFileImporter;
import com.paterva.maltego.graph.table.io.TabularGraphImporter;
import com.paterva.maltego.graph.table.io.TabularGraphIterator;
import com.paterva.maltego.graph.table.io.convert.TabularGraphPartFactory;
import com.paterva.maltego.graph.table.io.convert.TabularGraphTypes;
import com.paterva.maltego.graph.table.io.convert.TabularGraphUtils;
import com.paterva.maltego.graph.table.io.convert.TabularTranslator;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightEntity;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLightweightLink;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.tabular.transforms.run.MaltegoToLightEntities;
import com.paterva.maltego.tabular.transforms.run.TabularRowCounter;
import com.paterva.maltego.tabular.transforms.run.TabularTransformImporterFactory;
import com.paterva.maltego.transform.runner.api.AbstractTransform;
import com.paterva.maltego.transform.runner.api.MatchingRuleUpdater;
import com.paterva.maltego.transform.runner.api.TransformRunContext;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.util.Args;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class AbstractTabularTransformRunner
extends AbstractTransform {
    private static final Logger LOG = Logger.getLogger(AbstractTabularTransformRunner.class.getName());
    private final List<TabularTransformSource> sources;
    private final TabularTranslator translator;
    private final Map<TabularGraphLightweightEntity, MaltegoEntity> translatedEntities = new HashMap<TabularGraphLightweightEntity, MaltegoEntity>();
    private long rowCount;
    private long rowNum;
    private TabularGraphTypes types;
    private TabularGraphPartFactory partFactory;

    public AbstractTabularTransformRunner(TransformRunContext ctx, MatchingRuleUpdater matchingRuleUpdater, List<TabularTransformSource> sources) {
        super(ctx, matchingRuleUpdater);
        Args.notNullOrEmpty(sources, (String)"sources");
        this.sources = Collections.unmodifiableList(new ArrayList<TabularTransformSource>(sources));
        this.translator = new TabularTranslator(ctx.getEntityFactory(), ctx.getLinkFactory());
    }

    protected abstract TabularGraphPartFactory createPartFactory();

    protected abstract void processRow(TabularGraphIterator var1) throws Exception;

    public List<TabularTransformSource> getSources() {
        return this.sources;
    }

    protected TabularGraphTypes getTypes() {
        return this.types;
    }

    protected void doTransform() throws Exception {
        TransformRunContext ctx = this.getContext();
        TabularTransformImporterFactory importerFactory = new TabularTransformImporterFactory(ctx);
        Map<TabularTransformSource, List<TabularGraphFileImporter>> sourceImporters = importerFactory.getImporters(this.sources);
        this.rowCount = new TabularRowCounter().getRowCount(sourceImporters);
        LOG.log(Level.FINE, "Total row count: {0}", this.rowCount);
        for (Map.Entry<TabularTransformSource, List<TabularGraphFileImporter>> entry : sourceImporters.entrySet()) {
            TabularTransformSource source = entry.getKey();
            List<TabularGraphFileImporter> importers = entry.getValue();
            TabularGraph tabularGraph = MappingRegistry.getDefault().get(source.getTabularGraphName());
            this.types = new TabularGraphTypes(tabularGraph);
            this.partFactory = this.createPartFactory();
            for (TabularGraphImporter tabularGraphImporter : importers) {
                TabularGraphIterator rowIterator = tabularGraphImporter.open();
                Throwable throwable = null;
                try {
                    this.rowNum = -tabularGraph.getDataStartRowIndex();
                    while (rowIterator.hasNext()) {
                        if (this.rowNum >= 0L) {
                            this.processRow(rowIterator);
                            this.updateProgress((int)(100L * this.rowNum / this.rowCount));
                        }
                        if (this.isCanceled()) {
                            return;
                        }
                        ++this.rowNum;
                        rowIterator.next();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rowIterator == null) continue;
                    if (throwable != null) {
                        try {
                            rowIterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rowIterator.close();
                }
            }
        }
    }

    protected List<TabularGraphLightweightEntity> getRowEntities(TabularGraphIterator rowIterator) throws Exception {
        List<Object> row = this.getTrimmedRowValues(rowIterator, this.getTypes().getEntityColumnTypes());
        return this.partFactory.processEntities(row);
    }

    protected List<TabularGraphLightweightLink> getRowLinks(TabularGraphIterator rowIterator, List<TabularGraphLightweightEntity> entities) throws Exception {
        List<Object> row = this.getTrimmedRowValues(rowIterator, this.getTypes().getLinkColumnTypes());
        TabularGraphUtils.trimRowValues(row);
        return this.partFactory.processLinks(row, entities);
    }

    protected void sendResults(Map<MaltegoEntity, List<MaltegoEntity>> inputToOutputEntities, Map<MaltegoLink, LinkEntityIDs> links) throws Exception {
        super.sendResults(inputToOutputEntities, links, (int)(100L * this.rowNum / this.rowCount));
    }

    protected Map<MaltegoEntity, List<MaltegoEntity>> createOutputEntities(MaltegoToLightEntities entities) {
        Args.notNull((Object)entities, (String)"entities");
        return entities.entrySet().stream().collect(Collectors.toMap(entry -> (MaltegoEntity)entry.getKey(), entry -> this.createEntities((List)entry.getValue())));
    }

    private List<MaltegoEntity> createEntities(List<TabularGraphLightweightEntity> lightEntities) {
        return lightEntities.stream().map(this::getOrCreateEntity).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    protected Optional<MaltegoEntity> getOrCreateEntity(TabularGraphLightweightEntity lightEntity) {
        MaltegoEntity entity = this.translatedEntities.get(lightEntity);
        if (entity == null && (entity = (MaltegoEntity)this.translate(lightEntity).orElse(null)) != null) {
            this.translatedEntities.put(lightEntity, entity);
        }
        return Optional.ofNullable(entity);
    }

    protected Optional<MaltegoEntity> translate(TabularGraphLightweightEntity entity) {
        TabularGraphEntityType type = (TabularGraphEntityType)entity.type;
        try {
            return Optional.ofNullable(this.translator.translate(type.tabularEntity, entity.row));
        }
        catch (Exception ex) {
            this.warn("Error creating entity: " + ex.getMessage());
            return Optional.empty();
        }
    }

    protected Optional<MaltegoLink> translate(TabularGraphLightweightLink link) {
        TabularGraphLinkType type = (TabularGraphLinkType)link.type;
        try {
            return Optional.ofNullable(this.translator.translate(type.tabularLink, link.row));
        }
        catch (Exception ex) {
            this.warn("Error creating link: " + ex.getMessage());
            return Optional.empty();
        }
    }

    private List<Object> getTrimmedRowValues(TabularGraphIterator rowIterator, Map<Integer, TypeDescriptor> desiredColumnTypes) throws IOException {
        List row = rowIterator.getRow(desiredColumnTypes);
        TabularGraphUtils.trimRowValues((List)row);
        return row;
    }
}

