/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.PandoraConstants;
import com.pinkmatter.pandora.lucene.analysis.PunctuationQueryHelper;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;

public class FilterHelper {
    protected FilterHelper() {
    }

    public static <T> Query createSimpleQuery(String field, Class fieldClass, PandoraFilter<T> parameters) {
        Query query = null;
        if (parameters instanceof PandoraFilter.Contains) {
            PandoraFilter.Contains params = (PandoraFilter.Contains)parameters;
            Object val = ConvertUtils.convert((Object)params.getValue(), (Class)fieldClass);
            query = FilterHelper.createContainsQuery(field, val);
        } else if (parameters instanceof PandoraFilter.Between) {
            PandoraFilter.Between params = (PandoraFilter.Between)parameters;
            Object valFrom = ConvertUtils.convert((Object)params.getFrom(), (Class)fieldClass);
            Object valTo = ConvertUtils.convert((Object)params.getTo(), (Class)fieldClass);
            query = FilterHelper.createRangeQuery(field, valFrom, valTo, params.isIncluding());
        } else if (parameters instanceof PandoraFilter.GreaterThan) {
            PandoraFilter.GreaterThan params = (PandoraFilter.GreaterThan)parameters;
            Object val = ConvertUtils.convert((Object)params.getValue(), (Class)fieldClass);
            query = FilterHelper.createGreaterQuery(field, val, params.isIncluding());
        } else if (parameters instanceof PandoraFilter.LessThan) {
            PandoraFilter.LessThan params = (PandoraFilter.LessThan)parameters;
            Object val = ConvertUtils.convert((Object)params.getValue(), (Class)fieldClass);
            query = FilterHelper.createLessQuery(field, val, params.isIncluding());
        }
        if (query != null) {
            return query;
        }
        throw new UnsupportedOperationException("This type of filter is not supported: " + parameters.toString());
    }

    public static <T> Query createSimpleQuery(String field, PandoraFilter<T> parameters) {
        Query query = null;
        if (parameters instanceof PandoraFilter.Contains) {
            PandoraFilter.Contains params = (PandoraFilter.Contains)parameters;
            query = FilterHelper.createContainsQuery(field, params.getValue());
        } else if (parameters instanceof PandoraFilter.Between) {
            PandoraFilter.Between params = (PandoraFilter.Between)parameters;
            query = FilterHelper.createRangeQuery(field, params.getFrom(), params.getTo(), params.isIncluding());
        } else if (parameters instanceof PandoraFilter.GreaterThan) {
            PandoraFilter.GreaterThan params = (PandoraFilter.GreaterThan)parameters;
            query = FilterHelper.createGreaterQuery(field, params.getValue(), params.isIncluding());
        } else if (parameters instanceof PandoraFilter.LessThan) {
            PandoraFilter.LessThan params = (PandoraFilter.LessThan)parameters;
            query = FilterHelper.createLessQuery(field, params.getValue(), params.isIncluding());
        }
        if (query != null) {
            return query;
        }
        throw new UnsupportedOperationException("This type of filter is not supported: " + parameters.toString());
    }

    private static <T> Query createRangeQuery(String property, T from, T to, boolean include) {
        Class<?> clazz = from != null ? from.getClass() : to.getClass();
        if (clazz == String.class) {
            return TermRangeQuery.newStringRange((String)property, (String)(from == null ? null : ((String)from).toLowerCase()), (String)(to == null ? null : ((String)to).toLowerCase()), (boolean)include, (boolean)include);
        }
        if (clazz == Integer.class) {
            return NumericRangeQuery.newIntRange((String)property, (Integer)((Integer)from), (Integer)((Integer)to), (boolean)include, (boolean)include);
        }
        if (clazz == Double.class) {
            return NumericRangeQuery.newDoubleRange((String)property, (Double)((Double)from), (Double)((Double)to), (boolean)include, (boolean)include);
        }
        if (clazz == Long.class) {
            return NumericRangeQuery.newLongRange((String)property, (Long)((Long)from), (Long)((Long)to), (boolean)include, (boolean)include);
        }
        if (clazz == Float.class) {
            return NumericRangeQuery.newFloatRange((String)property, (Float)((Float)from), (Float)((Float)to), (boolean)include, (boolean)include);
        }
        if (clazz == BigInteger.class) {
            return TermRangeQuery.newStringRange((String)property, (String)(from == null ? null : from + ""), to == null ? null : to + "", (boolean)include, (boolean)include);
        }
        return null;
    }

    private static <T> Query createGreaterQuery(String property, T from, boolean include) {
        return FilterHelper.createRangeQuery(property, from, null, include);
    }

    private static <T> Query createLessQuery(String property, T to, boolean include) {
        return FilterHelper.createRangeQuery(property, null, to, include);
    }

    private static <T> Query createContainsQuery(String property, T value) {
        if (value.getClass() == String.class) {
            return new TermQuery(new Term(property, ((String)value).toLowerCase()));
        }
        return FilterHelper.createRangeQuery(property, value, value, true);
    }

    protected static Query createTermsQuery(List<Term> terms) {
        return new TermsQuery(terms);
    }

    public static Query createOrQuery(Query ... queries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Query filter : queries) {
            builder.add(filter, BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public static Query createAndFilter(Query ... queries) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Query filter : queries) {
            builder.add(filter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    public static Query createAndNotFilter(Query andQuery, Query notQuery) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(andQuery, BooleanClause.Occur.FILTER);
        builder.add(notQuery, BooleanClause.Occur.MUST_NOT);
        return builder.build();
    }

    public static Query createNotFilter(Query notQuery) {
        return FilterHelper.createAndNotFilter((Query)new MatchAllDocsQuery(), notQuery);
    }

    public static Query createEmptyFilter(String field) {
        return FilterHelper.createAndNotFilter((Query)new MatchAllDocsQuery(), (Query)new FieldValueQuery(field));
    }

    public static Query createNotEmptyFilter(String field) {
        return new FieldValueQuery(field);
    }

    public static Query createMatchNothingFilter() {
        return new MatchNoDocsQuery();
    }

    public static Query createLikeQuery(String field, String queryString) throws PandoraException {
        queryString = PunctuationQueryHelper.translate(queryString);
        return FilterHelper.createLikeQueryWithStandardParser(field, queryString);
    }

    private static Query createLikeQueryWthSimpleParser(String field, String queryString) throws PandoraException {
        SimpleQueryParser parser = new SimpleQueryParser(PandoraConstants.getTextAnalyzer(), field);
        parser.setDefaultOperator(BooleanClause.Occur.MUST);
        Query query = parser.parse(queryString);
        return query;
    }

    private static Query createLikeQueryWithStandardParser(String field, String queryString) throws PandoraException {
        try {
            queryString = FilterHelper.singleToDoublePipe(queryString);
            StandardQueryParser parser = new StandardQueryParser(PandoraConstants.getTextAnalyzer());
            parser.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
            parser.setAllowLeadingWildcard(true);
            Query query = parser.parse(queryString, field);
            query = FilterHelper.fixOnlyNotClauses(query);
            return query;
        }
        catch (QueryNodeException ex) {
            throw new PandoraException(String.format("Error creating Like query for field %s and query %s.", field, queryString), (Throwable)ex);
        }
    }

    private static Query fixOnlyNotClauses(Query query) {
        if (query instanceof BooleanQuery) {
            BooleanQuery bool = (BooleanQuery)query;
            boolean allNots = true;
            for (BooleanClause clause : bool) {
                if (clause.getOccur() == BooleanClause.Occur.MUST_NOT) continue;
                allNots = false;
                break;
            }
            if (allNots) {
                BooleanQuery.Builder builder = new BooleanQuery.Builder();
                builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
                for (BooleanClause clause : bool) {
                    builder.add(clause);
                }
                query = builder.build();
            }
        }
        return query;
    }

    private static String singleToDoublePipe(String text) {
        text = text.replaceAll("\\s+\\|(?![\\|])", " ||");
        return text;
    }
}

