/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.lucene.serialize.DocumentProperty;
import com.pinkmatter.pandora.lucene.serialize.TypeConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentPropertyCollector {
    private final Map<String, DocumentProperty> _properties = new LinkedHashMap<String, DocumentProperty>();
    private static final Logger LOG = LoggerFactory.getLogger(DocumentPropertyCollector.class);

    public void collectAll(List<IndexableField> fields) throws PandoraException {
        for (IndexableField indexField : fields) {
            this.collect(indexField);
        }
    }

    public void collectAll(List<IndexableField> fields, String prefix) throws PandoraException {
        for (IndexableField indexField : fields) {
            this.collect(indexField, prefix);
        }
    }

    public void collect(IndexableField field) throws PandoraException {
        this.collect(field, "");
    }

    public void collect(IndexableField field, String prefix) throws PandoraException {
        String fieldName = field.name().substring(prefix.length());
        TypeConverter converter = TypeConverter.get(fieldName);
        if (converter == null) {
            if (prefix.isEmpty()) {
                throw new PandoraException(String.format("Could not find a TypeConverter for field: %s.", field.name()));
            }
            throw new PandoraException(String.format("Could not find a TypeConverter for field: %s with prefix: %s.", field.name(), prefix));
        }
        String property = converter.getProperty(fieldName);
        DocumentProperty collector = this.getOrCreateProperty(property, prefix, converter);
        collector.add(field);
    }

    public static List<IndexableField> filter(String filterProperty, List<IndexableField> fields) throws PandoraException {
        ArrayList<IndexableField> filtered = new ArrayList<IndexableField>();
        for (IndexableField field : fields) {
            TypeConverter converter = TypeConverter.get(field.name());
            if (converter == null) {
                throw new PandoraException(String.format("Could not find a TypeConverter for field: %s.", field.name()));
            }
            String property = converter.getProperty(field.name());
            if (!property.equals(property)) continue;
            filtered.add(field);
        }
        return filtered;
    }

    private DocumentProperty getOrCreateProperty(String property, String prefix, TypeConverter converter) throws PandoraException {
        DocumentProperty propertyField = this._properties.get(property);
        if (propertyField == null) {
            propertyField = new DocumentProperty(property, prefix, converter);
            this._properties.put(property, propertyField);
        } else if (!converter.equals(propertyField.getConverter())) {
            LOG.error("Cannot read a document property with the same name: {} but different converters: {} and {}", new Object[]{property, propertyField.getConverter(), converter});
            throw new PandoraException(String.format("Cannot read a document property with the same name: %s, prefix: %s but different converter: %s and: %s within the same document.", property, prefix, propertyField.getConverter(), converter));
        }
        return propertyField;
    }

    public Collection<DocumentProperty> getProperties() {
        return this._properties.values();
    }

    public DocumentProperty getProperty(String property) {
        return this._properties.get(property);
    }
}

