/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene;

import com.pinkmatter.pandora.lucene.analysis.PunctuationAnlayzer;
import org.apache.lucene.LucenePackage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene54.Lucene54Codec;

public class PandoraConstants {
    public static final String KEY = "__key";
    public static final String INDEX_DATE = "__index-date";
    public static final String BIRTH_DATE = "__birth-date";
    private static Analyzer _analyzer;
    private static int _stringLimit;

    public static Analyzer getTextAnalyzer() {
        if (_analyzer == null) {
            _analyzer = new PunctuationAnlayzer();
        }
        return _analyzer;
    }

    public static int getExactMatchStringLimit() {
        return _stringLimit;
    }

    public static void setExactMatchStringLimit(int limit) {
        _stringLimit = limit;
    }

    public static Codec getCodec() {
        return new Lucene54Codec(Lucene50StoredFieldsFormat.Mode.BEST_SPEED);
    }

    public static String getLuceneVersion() {
        return LucenePackage.get().getSpecificationVersion();
    }

    static {
        _stringLimit = 1000;
    }
}

