/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.hub;

import com.paterva.maltego.graph.table.io.TabularGraphFileImporterFactory;
import com.paterva.maltego.transforms.tabular.ui.hub.ObservableTabularTransformSourceHoverAwarePanel;
import com.paterva.maltego.transforms.tabular.ui.hub.TabularTransformSourceHoverPanel;
import com.paterva.maltego.transforms.tabular.ui.hub.TabularTransformSourceItemDescriptor;
import com.paterva.maltego.transforms.tabular.ui.hub.TabularTransformSourceMainPanel;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TabularTransformSourcePanel
extends ObservableTabularTransformSourceHoverAwarePanel {
    private static final Dimension ICON_DIMENSION_LARGE_48 = new Dimension(IconSize.LARGE.getSize(), IconSize.LARGE.getSize());
    private static final String MAIN_CARD = "main";
    private static final String HOVER_CARD = "hover";
    private final TabularTransformSourceItemDescriptor item;
    private final CardLayout cardLayout;
    private JPanel cardPanel;
    private JLabel iconLabel;
    private JPanel typePanel;

    public TabularTransformSourcePanel(TabularTransformSourceItemDescriptor item) {
        Args.notNull((Object)((Object)item), (String)"item");
        this.item = item;
        this.initComponents();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.cardPanel.add((Component)((Object)new TabularTransformSourceMainPanel(item)), MAIN_CARD);
        this.cardPanel.add((Component)((Object)new TabularTransformSourceHoverPanel(item)), HOVER_CARD);
        if (item != null) {
            this.update();
        }
    }

    @Override
    public TabularTransformSourceItemDescriptor getItem() {
        return this.item;
    }

    private void update() {
        this.updateType();
        this.updateIcon();
        this.updateBackground();
    }

    private void updateType() {
        this.typePanel.setVisible(false);
    }

    private void updateIcon() {
        ImageIcon imageIcon;
        File dsf;
        Optional importerFactoryOpt;
        List txSourceFiles;
        this.iconLabel.setText("");
        if (this.iconLabel.getIcon() == null && this.item != null && (txSourceFiles = this.item.getTransformSource().getSourceFiles()).size() > 0 && (importerFactoryOpt = TabularGraphFileImporterFactory.get((File)(dsf = new File((String)txSourceFiles.get(0))))).isPresent() && (imageIcon = ((TabularGraphFileImporterFactory)importerFactoryOpt.get()).getImageIcon()) != null) {
            this.setImage(imageIcon);
        }
    }

    private void setImage(ImageIcon icon) {
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
    }

    private void initComponents() {
        this.iconLabel = new JLabel();
        this.cardPanel = new JPanel();
        this.typePanel = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.iconLabel, (String)NbBundle.getMessage(TabularTransformSourcePanel.class, (String)"TabularTransformSourcePanel.iconLabel.text"));
        this.iconLabel.setMaximumSize(ICON_DIMENSION_LARGE_48);
        this.iconLabel.setMinimumSize(ICON_DIMENSION_LARGE_48);
        this.iconLabel.setPreferredSize(ICON_DIMENSION_LARGE_48);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 3);
        this.add(this.iconLabel, gridBagConstraints);
        this.cardPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.cardPanel, gridBagConstraints);
        this.typePanel.setMaximumSize(new Dimension(4, Short.MAX_VALUE));
        this.typePanel.setMinimumSize(new Dimension(4, 4));
        this.typePanel.setPreferredSize(new Dimension(4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.typePanel, gridBagConstraints);
    }

    protected void onHoveredChanged() {
        this.updateBackground();
        this.cardLayout.show(this.cardPanel, this.isHovered(false) ? HOVER_CARD : MAIN_CARD);
    }

    protected void onPanelClicked() {
    }

    private void updateBackground() {
        String colorString = this.isHovered(false) ? "hub-item-hover-datasource-bg" : "hub-item-datasource-bg";
        Color bgColor = UIManager.getLookAndFeelDefaults().getColor(colorString);
        this.setBackground(bgColor);
        this.repaint();
    }
}

