/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transforms.tabular.ui.details.files;

import com.paterva.maltego.graph.table.ui.wizard.ImportFileController;
import com.paterva.maltego.transforms.tabular.TabularTransformSourceRepository;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import java.awt.FlowLayout;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;

public class TabularFilesButtonPanel
extends JPanel {
    private TabularTransformSource transformSource;

    public TabularFilesButtonPanel() {
        this.setLayout(new FlowLayout(0, 6, 6));
        JButton addButton = new JButton("Add");
        addButton.addActionListener(evt -> this.onAdd());
        this.add(addButton);
    }

    public void setTransformSource(TabularTransformSource transformSource) {
        Args.notNull((Object)transformSource, (String)"transformSource");
        this.transformSource = transformSource;
    }

    private void onAdd() {
        ImportFileController controller = new ImportFileController();
        EditDialogDescriptor descriptor = new EditDialogDescriptor((WizardDescriptor.Panel)controller);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (NotifyDescriptor.OK_OPTION.equals(result)) {
            try {
                TabularTransformSourceRepository tabularTransformSourceRepo = TabularTransformSourceRepository.getInstance();
                List files = (List)descriptor.getProperty("files");
                List filesList = files.stream().map(File::getPath).collect(Collectors.toList());
                for (String file : filesList) {
                    tabularTransformSourceRepo.update((Object)this.transformSource.addSourceFile(file));
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

