/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.customicons.manage;

import com.paterva.maltego.customicons.manage.IconNameEditPanel;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.WizardDescriptor;

public class IconNameController
extends ValidatingController<IconNameEditPanel> {
    public static final String ICON_CATEGORY = "iconCategory";
    public static final String ICON_NAME = "iconName";
    private String _iconCategory;
    private String _previousName;
    private final boolean _alias;
    private final String _label;

    public IconNameController(String label, boolean alias) {
        this._label = label;
        this._alias = alias;
        this.setName("Enter Icon " + this._label);
    }

    protected IconNameEditPanel createComponent() {
        IconNameEditPanel panel = new IconNameEditPanel(this._label);
        panel.addChangeListener(this.changeListener());
        return panel;
    }

    protected String getFirstError(IconNameEditPanel component) {
        String error = null;
        String name = component.getIconName().trim();
        if (!name.equals(this._previousName)) {
            Pattern p;
            Matcher matcher;
            error = name.isEmpty() ? "The " + (this._alias ? "alias" : "icon") + " name may not be empty." : (!this._alias && !name.matches(IconNameController.getNamePatternString()) ? "Only alphabetic characters, spaces and underscores allowed." : (this._alias ? (!(matcher = (p = IconNameController.getAliasPattern()).matcher(name)).matches() ? "Only UTF8 word characters, spaces and .,-'()[] characters allowed." : this.validateOther(name, error)) : this.validateOther(name, error)));
        }
        return error;
    }

    public static String getNamePatternString() {
        return "^[a-zA-Z _]+$";
    }

    public static Pattern getAliasPattern() {
        return Pattern.compile("^[\\w \\.,\\-\\'(\\)\\[\\]]+$", 256);
    }

    private String validateOther(String name, String error) {
        Optional iconOpt = IconRegistry.getDefault().findRegistryIcon(new VirtualIcon(this._iconCategory, name));
        if (iconOpt.isPresent()) {
            RegistryIcon icon = (RegistryIcon)iconOpt.get();
            error = "Icon name/alias already exists: " + icon.getCategory() + " > " + icon.getName();
        }
        return error;
    }

    protected void readSettings(WizardDescriptor settings) {
        String iconName = (String)settings.getProperty(ICON_NAME);
        ((IconNameEditPanel)this.component()).setIconName(iconName);
        this._previousName = iconName;
        String iconCategory = (String)settings.getProperty(ICON_CATEGORY);
        ((IconNameEditPanel)this.component()).setIconCategory(iconCategory);
        this._iconCategory = iconCategory;
    }

    protected void storeSettings(WizardDescriptor settings) {
        String iconName = ((IconNameEditPanel)this.component()).getIconName();
        settings.putProperty(ICON_NAME, (Object)iconName);
        String iconCategory = ((IconNameEditPanel)this.component()).getIconCategory();
        settings.putProperty(ICON_CATEGORY, (Object)iconCategory);
    }
}

