/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.undo;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.undo.Command;
import com.paterva.maltego.graph.undo.UndoRedoManager;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.UndoRedo;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.common.model.ActionRepeatableButtonModel;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public abstract class UndoRedoStackAction
extends AbstractAction
implements RibbonPresenter.Button,
PropertyChangeListener,
ChangeListener,
Runnable {
    private JCommandButton _button;
    private UndoRedo _last = UndoRedo.NONE;

    public UndoRedoStackAction() {
        SwingUtilities.invokeLater(() -> this.initializeUndoRedo());
    }

    public abstract String getName();

    public abstract String getDescription();

    protected abstract String iconResource();

    protected abstract Command[] getCommands();

    protected abstract ActionListener createActionListener(Command var1);

    protected abstract void updateEnabledState();

    private void initializeUndoRedo() {
        assert (EventQueue.isDispatchThread());
        GraphEditorRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this._last = UndoRedo.NONE;
        this.run();
        this.updateEnabledState();
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this);
            return;
        }
        UndoRedo ur = this.getUndoAndRedo();
        if (!Utilities.compareObjects((Object)this._last, (Object)ur)) {
            this._last.removeChangeListener((ChangeListener)this);
            this.updateEnabledState();
            this._last = ur;
            this._last.addChangeListener((ChangeListener)this);
        }
    }

    protected UndoRedo getUndoAndRedo() {
        UndoRedo ur;
        assert (EventQueue.isDispatchThread());
        TopComponent el = GraphEditorRegistry.getDefault().getTopmost();
        if (el != null && (ur = el.getUndoRedo()) != null) {
            return ur;
        }
        return UndoRedo.NONE;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if ("activated".equals(ev.getPropertyName())) {
            this.run();
        }
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.updateEnabledState();
    }

    protected UndoRedoModel getUndoRedo() {
        GraphID graphID;
        GraphCookie cookie;
        UndoRedoModel undoRedo = null;
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (topmost != null && (cookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) != null && (graphID = cookie.getGraphID()) != null) {
            undoRedo = UndoRedoManager.getDefault().get(graphID);
        }
        return undoRedo;
    }

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
            RichTooltip tooltip = new RichTooltip(this.getName(), this.getDescription());
            tooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource().replace(".png", "48.png")));
            this.addFooter(tooltip);
            this._button.setActionRichTooltip(tooltip);
            this._button.setPopupRichTooltip(tooltip);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UndoRedoStackAction.this.actionPerformed(null);
                }
            });
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return UndoRedoStackAction.this.createPopup(UndoRedoStackAction.this.getCommands());
                }
            });
        }
        return this._button;
    }

    protected JCommandPopupMenu createPopup(Command[] commands) {
        JCommandPopupMenu menu = new JCommandPopupMenu();
        for (Command command : commands) {
            if (!command.isSignificant()) continue;
            menu.addMenuButton(this.createMenuButton(command, menu, this.createActionListener(command)));
        }
        if (menu.getMenuComponents().isEmpty()) {
            JCommandMenuButton button = new JCommandMenuButton("<empty>", null);
            button.setEnabled(false);
            menu.addMenuButton(button);
        }
        return menu;
    }

    protected JCommandMenuButton createMenuButton(Command command, JCommandPopupMenu menu, ActionListener listener) {
        JCommandMenuButton menuButton = new JCommandMenuButton(command.getDescription(), null);
        menuButton.setActionModel((ActionButtonModel)new AllUpToButtonModel(menu, menuButton));
        RichTooltip tooltip = this.createTooltip(command);
        if (tooltip != null) {
            menuButton.setActionRichTooltip(tooltip);
        }
        menuButton.addActionListener(listener);
        return menuButton;
    }

    protected RichTooltip createTooltip(Command command) {
        RichTooltip tooltip = new RichTooltip(command.getDescription(), command.getDescription());
        tooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource()));
        this.addFooter(tooltip);
        return tooltip;
    }

    protected void addFooter(RichTooltip tooltip) {
        tooltip.addFooterSection("Click the help button to get more help on Maltego features");
        tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
    }

    protected class AllUpToButtonModel
    extends ActionRepeatableButtonModel {
        private final JCommandPopupMenu _menu;
        private final JCommandMenuButton _menuButton;

        public AllUpToButtonModel(JCommandPopupMenu menu, JCommandMenuButton menuButton) {
            super((JCommandButton)menuButton);
            this._menu = menu;
            this._menuButton = menuButton;
        }

        public void setRollover(boolean b) {
            if (super.isRollover() != b) {
                super.setRollover(b);
                if (b) {
                    List menuComponents = this._menu.getMenuComponents();
                    for (Component component : menuComponents) {
                        if (!(component instanceof JCommandMenuButton)) continue;
                        JCommandMenuButton jCommandMenuButton = (JCommandMenuButton)component;
                        if (jCommandMenuButton == this._menuButton) break;
                        jCommandMenuButton.getActionModel().setRollover(true);
                    }
                }
            }
        }
    }
}

