/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.wizard;

import com.paterva.maltego.licensing.B;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LicenseWebLinksPanel
extends JPanel {
    private String licenseKey;
    private JButton buyPlanButton;
    private JButton comparePlansButton;
    private JButton renewButton;
    private JButton upgradeButton;

    public LicenseWebLinksPanel() {
        this(LicenseManager.A().A(false));
    }

    public LicenseWebLinksPanel(A licenseMode) {
        this.initComponents();
        Font font = this.buyPlanButton.getFont();
        font = font.deriveFont(0, font.getSize() - 1);
        this.buyPlanButton.setFont(font);
        this.comparePlansButton.setFont(font);
        this.upgradeButton.setFont(font);
        this.renewButton.setFont(font);
        if (licenseMode.D() || licenseMode.Q()) {
            this.buyPlanButton.setVisible(false);
            this.upgradeButton.setVisible(false);
            this.renewButton.setVisible(false);
        } else if (licenseMode.U()) {
            this.buyPlanButton.setVisible(false);
            this.upgradeButton.setVisible(MaltegoIdProductRestrictions.isProbablyFree((A)licenseMode));
            this.renewButton.setVisible(licenseMode.R().K());
        } else {
            this.licenseKey = licenseMode.A().C();
            this.buyPlanButton.setVisible(false);
            this.upgradeButton.setVisible(licenseMode.G());
            this.renewButton.setVisible(licenseMode.J().K());
        }
    }

    public void setLicenseKey(String licenseKey) {
        String validKey = B.C((String)licenseKey);
        boolean valid = validKey != null;
        this.licenseKey = valid ? validKey : null;
        this.renewButton.setEnabled(valid);
    }

    private void initComponents() {
        this.comparePlansButton = new JButton();
        this.buyPlanButton = new JButton();
        this.upgradeButton = new JButton();
        this.renewButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.comparePlansButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.comparePlansButton, (String)NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.comparePlansButton.text"));
        this.comparePlansButton.setToolTipText(NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.comparePlansButton.toolTipText"));
        this.comparePlansButton.setIconTextGap(6);
        this.comparePlansButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseWebLinksPanel.this.comparePlansButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.comparePlansButton, gridBagConstraints);
        this.buyPlanButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.buyPlanButton, (String)NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.buyPlanButton.text"));
        this.buyPlanButton.setToolTipText(NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.buyPlanButton.toolTipText"));
        this.buyPlanButton.setIconTextGap(6);
        this.buyPlanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseWebLinksPanel.this.buyPlanButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.buyPlanButton, gridBagConstraints);
        this.upgradeButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.upgradeButton, (String)NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.upgradeButton.text"));
        this.upgradeButton.setToolTipText(NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.upgradeButton.toolTipText"));
        this.upgradeButton.setIconTextGap(6);
        this.upgradeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseWebLinksPanel.this.upgradeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.upgradeButton, gridBagConstraints);
        this.renewButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/licensing/ui/resources/browser.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.renewButton, (String)NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.renewButton.text"));
        this.renewButton.setToolTipText(NbBundle.getMessage(LicenseWebLinksPanel.class, (String)"LicenseWebLinksPanel.renewButton.toolTipText"));
        this.renewButton.setIconTextGap(6);
        this.renewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LicenseWebLinksPanel.this.renewButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.renewButton, gridBagConstraints);
    }

    private void comparePlansButtonActionPerformed(ActionEvent evt) {
        BrowseToUrl.compareProducts(this.licenseKey);
    }

    private void buyPlanButtonActionPerformed(ActionEvent evt) {
        BrowseToUrl.buyPlan(this.licenseKey);
    }

    private void renewButtonActionPerformed(ActionEvent evt) {
        BrowseToUrl.renew(this.licenseKey);
    }

    private void upgradeButtonActionPerformed(ActionEvent evt) {
        BrowseToUrl.upgradePlan(this.licenseKey);
    }
}

