/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.ui.action;

import com.maltego.cloud.CloudAuth;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.serialize.N;
import com.paterva.maltego.licensing.ui.action.MaltegoIDLogoutCallback;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.ui.dialog.ProgressControlDialog;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.RequestProcessor;

public class MaltegoIdLogoutAction {
    private static final MaltegoIdLogoutAction INSTANCE = new MaltegoIdLogoutAction();

    private MaltegoIdLogoutAction() {
    }

    public static MaltegoIdLogoutAction getInstance() {
        return INSTANCE;
    }

    public synchronized void logout(RequestProcessor requestProcessor, Window ownerFrame, JButton closeButton, MaltegoIDLogoutCallback cb) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)"Are you sure to logout from Maltego?", "Logout", 0);
        Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (NotifyDescriptor.NO_OPTION.equals(result)) {
            return;
        }
        ProgressHandle progressHandle = ProgressHandleFactory.createUIHandle((String)"Logging out from server...", null, null);
        JDialog dialog = ProgressControlDialog.create((Window)ownerFrame, (String)"Logout", (ProgressHandle)progressHandle);
        RequestProcessor.Task task = requestProcessor.create(() -> {
            try {
                progressHandle.start();
                CloudAuth.getDefault().logout(false);
            }
            catch (Exception ex) {
                NormalException.logStackTrace((Throwable)ex);
            }
            finally {
                N.B().A();
                LicenseManager licenseManager = LicenseManager.A();
                licenseManager.C(false);
                licenseManager.B(false);
                licenseManager.H(false);
                licenseManager.G(false);
                licenseManager.I(false);
                licenseManager.E();
                SwingUtilities.invokeLater(() -> {
                    dialog.dispose();
                    if (closeButton != null) {
                        closeButton.doClick();
                    }
                    if (cb != null) {
                        cb.finished();
                    }
                });
            }
        });
        task.schedule(100);
        dialog.setVisible(true);
    }
}

