/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.DefaultSelectionMapper;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.decorator.SortController;
import org.jdesktop.swingx.decorator.SortKey;
import org.jdesktop.swingx.decorator.SortOrder;
import org.jdesktop.swingx.renderer.AbstractRenderer;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.ListRolloverController;
import org.jdesktop.swingx.rollover.ListRolloverProducer;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.search.ListSearchable;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXList
extends JList {
    private static final Logger LOG = Logger.getLogger(JXList.class.getName());
    public static final String EXECUTE_BUTTON_ACTIONCOMMAND = "executeButtonAction";
    protected FilterPipeline filters;
    protected CompoundHighlighter compoundHighlighter;
    private ChangeListener highlighterChangeListener;
    protected ComponentAdapter dataAdapter;
    private RolloverProducer rolloverProducer;
    private ListRolloverController<JXList> linkController;
    private DelegatingRenderer delegatingRenderer;
    private WrappingListModel wrappingModel;
    private PipelineListener pipelineListener;
    private boolean filterEnabled;
    private SelectionMapper selectionMapper;
    private Searchable searchable;
    private Comparator<?> comparator;

    public JXList() {
        this(false);
    }

    public JXList(ListModel dataModel) {
        this(dataModel, false);
    }

    public JXList(Object[] listData) {
        this(listData, false);
    }

    public JXList(Vector<?> listData) {
        this(listData, false);
    }

    public JXList(boolean filterEnabled) {
        this.init(filterEnabled);
    }

    public JXList(ListModel dataModel, boolean filterEnabled) {
        super(dataModel);
        this.init(filterEnabled);
    }

    public JXList(Object[] listData, boolean filterEnabled) {
        super(listData);
        if (listData == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(filterEnabled);
    }

    public JXList(Vector<?> listData, boolean filterEnabled) {
        super(listData);
        if (listData == null) {
            throw new IllegalArgumentException("listData must not be null");
        }
        this.init(filterEnabled);
    }

    private void init(boolean filterEnabled) {
        this.setFilterEnabled(filterEnabled);
        Action findAction = this.createFindAction();
        this.getActionMap().put("find", findAction);
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createFindAction() {
        return new UIAction("find"){

            public void actionPerformed(ActionEvent e) {
                JXList.this.doFind();
            }
        };
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new ListSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.addMouseListener(this.rolloverProducer);
            this.addMouseMotionListener(this.rolloverProducer);
            this.getLinkController().install(this);
        } else {
            this.removeMouseListener(this.rolloverProducer);
            this.removeMouseMotionListener(this.rolloverProducer);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    protected ListRolloverController<JXList> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected ListRolloverController<JXList> createLinkController() {
        return new ListRolloverController<JXList>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new ListRolloverProducer();
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    public void resetSortOrder() {
        SortController controller = this.getSortController();
        if (controller != null) {
            controller.setSortKeys(null);
        }
    }

    public void toggleSortOrder() {
        SortController controller = this.getSortController();
        if (controller != null) {
            controller.toggleSortOrder(0, this.getComparator());
        }
    }

    public void setSortOrder(SortOrder sortOrder) {
        if (sortOrder == null || !sortOrder.isSorted()) {
            this.resetSortOrder();
            return;
        }
        SortController sortController = this.getSortController();
        if (sortController != null) {
            SortKey sortKey = new SortKey(sortOrder, 0, this.getComparator());
            sortController.setSortKeys(Collections.singletonList(sortKey));
        }
    }

    public SortOrder getSortOrder() {
        SortController sortController = this.getSortController();
        if (sortController == null) {
            return SortOrder.UNSORTED;
        }
        SortKey sortKey = SortKey.getFirstSortKeyForColumn(sortController.getSortKeys(), 0);
        return sortKey != null ? sortKey.getSortOrder() : SortOrder.UNSORTED;
    }

    public Comparator<?> getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator<?> comparator) {
        Comparator<?> old = this.getComparator();
        this.comparator = comparator;
        this.updateSortAfterComparatorChange();
        this.firePropertyChange("comparator", old, this.getComparator());
    }

    protected void updateSortAfterComparatorChange() {
        this.setSortOrder(this.getSortOrder());
    }

    protected SortController getSortController() {
        if (!this.isFilterEnabled()) {
            return null;
        }
        return this.getFilters().getSortController();
    }

    public Object getElementAt(int viewIndex) {
        return this.getModel().getElementAt(viewIndex);
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    public int convertIndexToModel(int viewIndex) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToModel(viewIndex) : viewIndex;
    }

    public int convertIndexToView(int modelIndex) {
        return this.isFilterEnabled() ? this.getFilters().convertRowIndexToView(modelIndex) : modelIndex;
    }

    public ListModel getWrappedModel() {
        return this.isFilterEnabled() ? this.wrappingModel.getModel() : this.getModel();
    }

    public void setFilterEnabled(boolean enabled) {
        boolean old = this.isFilterEnabled();
        if (old == enabled) {
            return;
        }
        if (old) {
            throw new IllegalStateException("must not reset filterEnabled");
        }
        this.filterEnabled = enabled;
        this.wrappingModel = new WrappingListModel(this.getModel());
        super.setModel(this.wrappingModel);
        this.firePropertyChange("filterEnabled", old, this.isFilterEnabled());
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        super.setSelectionModel(newModel);
        this.getSelectionMapper().setViewSelectionModel(this.getSelectionModel());
    }

    public void setModel(ListModel model) {
        if (this.isFilterEnabled()) {
            this.wrappingModel.setModel(model);
        } else {
            super.setModel(model);
        }
    }

    protected SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = new DefaultSelectionMapper(this.filters, this.getSelectionModel());
        }
        return this.selectionMapper;
    }

    public FilterPipeline getFilters() {
        if (this.filters == null && this.isFilterEnabled()) {
            this.setFilters(null);
        }
        return this.filters;
    }

    public void setFilters(FilterPipeline pipeline) {
        if (!this.isFilterEnabled()) {
            throw new IllegalStateException("filters not enabled - not allowed to set filters");
        }
        FilterPipeline old = this.filters;
        List<? extends SortKey> sortKeys = null;
        if (old != null) {
            old.removePipelineListener(this.pipelineListener);
            sortKeys = old.getSortController().getSortKeys();
        }
        if (pipeline == null) {
            pipeline = new FilterPipeline();
        }
        this.filters = pipeline;
        this.filters.getSortController().setSortKeys(sortKeys);
        this.use(this.filters);
        this.getSelectionMapper().setFilters(this.filters);
    }

    private void use(FilterPipeline pipeline) {
        if (pipeline != null) {
            if (this.initialUse(pipeline)) {
                pipeline.addPipelineListener(this.getFilterPipelineListener());
                pipeline.assign(this.getComponentAdapter());
            } else {
                pipeline.flush();
            }
        }
    }

    private boolean initialUse(FilterPipeline pipeline) {
        if (this.pipelineListener == null) {
            return true;
        }
        PipelineListener[] l = pipeline.getPipelineListeners();
        for (int i = 0; i < l.length; ++i) {
            if (!this.pipelineListener.equals(l[i])) continue;
            return false;
        }
        return true;
    }

    protected PipelineListener getFilterPipelineListener() {
        if (this.pipelineListener == null) {
            this.pipelineListener = this.createPipelineListener();
        }
        return this.pipelineListener;
    }

    protected PipelineListener createPipelineListener() {
        return new PipelineListener(){

            public void contentsChanged(PipelineEvent e) {
                JXList.this.updateOnFilterContentChanged();
            }
        };
    }

    protected void updateOnFilterContentChanged() {
        if (this.wrappingModel != null) {
            this.wrappingModel.updateOnFilterContentChanged();
        }
        this.revalidate();
        this.repaint();
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new ListAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int index) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.column = 0;
        adapter.row = index;
        return adapter;
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighters);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JXList.this.repaint();
            }
        };
    }

    public String getStringAt(int row) {
        ListCellRenderer renderer = this.getDelegatingRenderer().getDelegateRenderer();
        if (renderer instanceof StringValue) {
            return ((StringValue)((Object)renderer)).getString(this.getElementAt(row));
        }
        return StringValues.TO_STRING.getString(this.getElementAt(row));
    }

    private DelegatingRenderer getDelegatingRenderer() {
        if (this.delegatingRenderer == null) {
            this.delegatingRenderer = new DelegatingRenderer();
        }
        return this.delegatingRenderer;
    }

    protected ListCellRenderer createDefaultCellRenderer() {
        return new DefaultListRenderer();
    }

    public ListCellRenderer getCellRenderer() {
        return this.getDelegatingRenderer();
    }

    public ListCellRenderer getWrappedCellRenderer() {
        return this.getDelegatingRenderer().getDelegateRenderer();
    }

    public void setCellRenderer(ListCellRenderer renderer) {
        this.getDelegatingRenderer().setDelegateRenderer(renderer);
        super.setCellRenderer(this.delegatingRenderer);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateRendererUI();
        this.updateHighlighterUI();
    }

    private void updateRendererUI() {
        if (this.delegatingRenderer != null) {
            this.delegatingRenderer.updateUI();
        } else {
            ListCellRenderer renderer = this.getCellRenderer();
            if (renderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)renderer));
            }
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    public class DelegatingRenderer
    implements ListCellRenderer,
    RolloverRenderer {
        private ListCellRenderer delegateRenderer;

        public DelegatingRenderer() {
            this(null);
        }

        public DelegatingRenderer(ListCellRenderer delegate) {
            this.setDelegateRenderer(delegate);
        }

        public void setDelegateRenderer(ListCellRenderer delegate) {
            if (delegate == null) {
                delegate = JXList.this.createDefaultCellRenderer();
            }
            this.delegateRenderer = delegate;
        }

        public ListCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public void updateUI() {
            this.updateRendererUI(this.delegateRenderer);
        }

        private void updateRendererUI(ListCellRenderer renderer) {
            if (renderer == null) {
                return;
            }
            Component comp = null;
            if (renderer instanceof AbstractRenderer) {
                comp = (Component)((AbstractRenderer)((Object)renderer)).getComponentProvider().getRendererComponent(null);
            } else if (renderer instanceof Component) {
                comp = (Component)((Object)renderer);
            } else {
                try {
                    comp = renderer.getListCellRendererComponent(JXList.this, null, -1, false, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (comp != null) {
                SwingUtilities.updateComponentTreeUI(comp);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = this.delegateRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (JXList.this.compoundHighlighter != null && index >= 0 && index < JXList.this.getElementCount()) {
                comp = JXList.this.compoundHighlighter.highlight(comp, JXList.this.getComponentAdapter(index));
            }
            return comp;
        }

        public boolean isEnabled() {
            return this.delegateRenderer instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.delegateRenderer)).isEnabled();
        }

        public void doClick() {
            if (this.isEnabled()) {
                ((RolloverRenderer)((Object)this.delegateRenderer)).doClick();
            }
        }
    }

    protected static class ListAdapter
    extends ComponentAdapter {
        private final JXList list;

        public ListAdapter(JXList component) {
            super(component);
            this.list = component;
        }

        public JXList getList() {
            return this.list;
        }

        public boolean hasFocus() {
            return this.list.isFocusOwner() && this.row == this.list.getLeadSelectionIndex();
        }

        public int getRowCount() {
            return this.list.getWrappedModel().getSize();
        }

        public Object getValue() {
            return this.list.getElementAt(this.row);
        }

        public Object getValueAt(int row, int column) {
            return this.list.getWrappedModel().getElementAt(row);
        }

        public Object getFilteredValueAt(int row, int column) {
            return this.list.getElementAt(row);
        }

        public String getFilteredStringAt(int row, int column) {
            return this.list.getStringAt(row);
        }

        public String getString() {
            return this.list.getStringAt(this.row);
        }

        public String getStringAt(int row, int column) {
            ListCellRenderer renderer = this.list.getDelegatingRenderer().getDelegateRenderer();
            if (renderer instanceof StringValue) {
                return ((StringValue)((Object)renderer)).getString(this.getValueAt(row, column));
            }
            return StringValues.TO_STRING.getString(this.getValueAt(row, column));
        }

        public void setValueAt(Object aValue, int row, int column) {
            throw new UnsupportedOperationException("The model is immutable.");
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public boolean isEditable() {
            return false;
        }

        public boolean isSelected() {
            return this.list.isSelectedIndex(this.row);
        }
    }

    private class WrappingListModel
    extends AbstractListModel {
        private ListModel delegate;
        private ListDataListener listDataListener;
        private Point OUTSIDE = new Point(-1, -1);
        protected boolean ignoreFilterContentChanged;

        public WrappingListModel(ListModel model) {
            this.setModel(model);
        }

        public void updateOnFilterContentChanged() {
            if (this.ignoreFilterContentChanged) {
                return;
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public void setModel(ListModel model) {
            ListModel old = this.getModel();
            if (old != null) {
                old.removeListDataListener(this.listDataListener);
            }
            this.delegate = model;
            this.delegate.addListDataListener(this.getListDataListener());
            this.fireContentsChanged(this, -1, -1);
            JXList.this.getSelectionMapper().clearModelSelection();
            JXList.this.getFilters().flush();
        }

        private ListDataListener getListDataListener() {
            if (this.listDataListener == null) {
                this.listDataListener = this.createListDataListener();
            }
            return this.listDataListener;
        }

        private ListDataListener createListDataListener() {
            return new ListDataListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void intervalAdded(ListDataEvent e) {
                    boolean wasEnabled = JXList.this.getSelectionMapper().isEnabled();
                    JXList.this.getSelectionMapper().setEnabled(false);
                    try {
                        WrappingListModel.this.updateModelSelection(e);
                        WrappingListModel.this.ignoreFilterContentChanged = true;
                        JXList.this.getFilters().flush();
                        WrappingListModel.this.ignoreFilterContentChanged = false;
                        WrappingListModel.this.refireMappedEvent(WrappingListModel.this.getMappedEvent(e));
                    }
                    finally {
                        JXList.this.getSelectionMapper().setEnabled(wasEnabled);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void intervalRemoved(ListDataEvent e) {
                    boolean wasEnabled = JXList.this.getSelectionMapper().isEnabled();
                    JXList.this.getSelectionMapper().setEnabled(false);
                    try {
                        WrappingListModel.this.updateModelSelection(e);
                        ListDataEvent mappedEvent = WrappingListModel.this.getMappedEvent(e);
                        WrappingListModel.this.ignoreFilterContentChanged = true;
                        JXList.this.getFilters().flush();
                        WrappingListModel.this.ignoreFilterContentChanged = false;
                        WrappingListModel.this.refireMappedEvent(mappedEvent);
                    }
                    finally {
                        JXList.this.getSelectionMapper().setEnabled(wasEnabled);
                    }
                }

                public void contentsChanged(ListDataEvent e) {
                    WrappingListModel.this.updateInternals(e);
                    WrappingListModel.this.refireContentsChanged(e);
                }
            };
        }

        private void refireContentsChanged(ListDataEvent e) {
            if (e.getIndex0() >= 0 && e.getIndex0() == e.getIndex1()) {
                int viewIndex = JXList.this.convertIndexToView(e.getIndex0());
                if (viewIndex == -1) {
                    return;
                }
                this.fireContentsChanged(this, viewIndex, viewIndex);
            } else if (e.getIndex0() >= 0) {
                this.fireContentsChanged(this, 0, this.getSize());
            } else {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        protected void refireMappedEvent(ListDataEvent mappedEvent) {
            if (mappedEvent == null) {
                return;
            }
            if (mappedEvent.getType() == 2) {
                this.fireIntervalRemoved(this, mappedEvent.getIndex0(), mappedEvent.getIndex1());
            } else if (mappedEvent.getType() == 1) {
                this.fireIntervalAdded(this, mappedEvent.getIndex0(), mappedEvent.getIndex1());
            } else {
                this.fireContentsChanged(this, mappedEvent.getIndex0(), mappedEvent.getIndex1());
            }
        }

        private ListDataEvent getMappedEvent(ListDataEvent e) {
            if (e.getIndex0() != -1 && e.getIndex0() == e.getIndex1()) {
                int viewIndex = JXList.this.convertIndexToView(e.getIndex0());
                if (viewIndex == -1) {
                    return null;
                }
                return new ListDataEvent(this, e.getType(), viewIndex, viewIndex);
            }
            Point mappedRange = this.getContinousMappedRange(e);
            if (mappedRange == null) {
                return new ListDataEvent(this, 0, -1, -1);
            }
            if (this.OUTSIDE == mappedRange) {
                return null;
            }
            return new ListDataEvent(this, e.getType(), mappedRange.x, mappedRange.y);
        }

        protected Point getContinousMappedRange(ListDataEvent e) {
            int i;
            ArrayList<Integer> mapped = new ArrayList<Integer>();
            for (i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                int viewIndex = JXList.this.convertIndexToView(i);
                if (viewIndex < 0) continue;
                mapped.add(viewIndex);
            }
            if (mapped.size() == 0) {
                return this.OUTSIDE;
            }
            if (mapped.size() == 1) {
                return new Point((Integer)mapped.get(0), (Integer)mapped.get(0));
            }
            Collections.sort(mapped);
            for (i = 0; i < mapped.size() - 2; ++i) {
                if ((Integer)mapped.get(i + 1) - (Integer)mapped.get(i) == 1) continue;
                return null;
            }
            return new Point((Integer)mapped.get(0), (Integer)mapped.get(mapped.size() - 1));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateInternals(ListDataEvent e) {
            boolean wasEnabled = JXList.this.getSelectionMapper().isEnabled();
            JXList.this.getSelectionMapper().setEnabled(false);
            try {
                this.updateModelSelection(e);
            }
            finally {
                JXList.this.getSelectionMapper().setEnabled(wasEnabled);
            }
            this.ignoreFilterContentChanged = true;
            JXList.this.getFilters().flush();
            this.ignoreFilterContentChanged = false;
        }

        protected void updateModelSelection(ListDataEvent e) {
            if (e.getType() == 2) {
                JXList.this.getSelectionMapper().removeIndexInterval(e.getIndex0(), e.getIndex1());
            } else if (e.getType() == 1) {
                int minIndex = Math.min(e.getIndex0(), e.getIndex1());
                int maxIndex = Math.max(e.getIndex0(), e.getIndex1());
                int length = maxIndex - minIndex + 1;
                JXList.this.getSelectionMapper().insertIndexInterval(minIndex, length, true);
            } else if (e.getIndex0() == -1) {
                JXList.this.getSelectionMapper().clearModelSelection();
            }
        }

        public ListModel getModel() {
            return this.delegate;
        }

        public int getSize() {
            return JXList.this.getFilters().getOutputSize();
        }

        public Object getElementAt(int index) {
            return JXList.this.getFilters().getValueAt(index, 0);
        }
    }
}

