/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.serializer;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.serializer.DisplayDescriptorTranslator;
import com.paterva.maltego.typing.serializer.FieldGroupsStub;
import com.paterva.maltego.typing.serializer.FieldStub;
import com.paterva.maltego.typing.serializer.GroupsTranslator;
import com.paterva.maltego.typing.serializer.PropertiesStub;
import com.paterva.maltego.util.XmlSerializationException;
import com.paterva.maltego.util.XmlSerializer;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class FieldsSerializer {
    public PropertiesStub createSerializationStub(PropertyConfiguration properties) throws XmlSerializationException {
        DisplayDescriptorTranslator translator = new DisplayDescriptorTranslator();
        GroupsTranslator groupsTranslator = new GroupsTranslator();
        List<FieldStub> fields = translator.translate(properties.getProperties());
        FieldGroupsStub groups = groupsTranslator.translate(properties.getGroups());
        PropertiesStub stub = new PropertiesStub(fields, groups);
        stub.setValueProperty(FieldsSerializer.getSpecialProperty(properties, "value"));
        return stub;
    }

    public void write(OutputStream stream, PropertyConfiguration properties) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        serializer.write((Object)this.createSerializationStub(properties), stream);
    }

    private static String getSpecialProperty(PropertyConfiguration properties, String name) {
        DisplayDescriptor descriptor = properties.getSpecialProperty(name);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getName();
    }

    public PropertyConfiguration readSerializationStub(PropertiesStub stub) throws XmlSerializationException {
        if (stub == null) {
            return null;
        }
        GroupsTranslator groupsTranslator = new GroupsTranslator();
        DisplayDescriptorTranslator translator = new DisplayDescriptorTranslator();
        PropertyConfiguration config = new PropertyConfiguration(translator.translate(stub.getFields()), groupsTranslator.translate(stub.getGroups()));
        FieldsSerializer.addSpecialProperty(config, "value", stub.getValueProperty());
        return config;
    }

    public PropertyConfiguration read(InputStream stream) throws XmlSerializationException {
        XmlSerializer serializer = new XmlSerializer();
        PropertiesStub stub = (PropertiesStub)serializer.read(PropertiesStub.class, stream);
        return this.readSerializationStub(stub);
    }

    private static void addSpecialProperty(PropertyConfiguration config, String name, String property) {
        DisplayDescriptor descriptor = config.getProperties().get(property);
        if (descriptor != null) {
            config.setSpecialProperty(name, descriptor);
        }
    }
}

